% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity_Lc}
\alias{sensitivity_Lc}
\title{Sensitivity to Lc}
\usage{
sensitivity_Lc(MLZ_data, MLZ_model, Lc.vec, grid.search = FALSE,
  figure = TRUE)
}
\arguments{
\item{MLZ_data}{An object of class \code{\linkS4class{MLZ_data}} containing mean lengths and
life history data of stock. Must contain length composition data.}

\item{MLZ_model}{An object of class \code{\linkS4class{MLZ_model}} with base value of Lc.}

\item{Lc.vec}{A vector of alternative Lc values.}

\item{grid.search}{Whether a grid search is performed or not. By default, the starting values 
in the sensitivity analysis are the estimates from object \code{MLZ_model}.}

\item{figure}{Whether a figure will be produced, similar to Figure 6 of Huynh et al. (2017).}
}
\value{
A matrix of mortality and change point estimates with each value Lc.
}
\description{
The function re-calculates mean lengths for each alternative value of Lc and 
re-estimates mortality. Currently supports only the ML estimator.
}
\examples{
data(SilkSnapper)
new.dataset <- new("MLZ_data", Year = 1983:2013, Len_df = SilkSnapper, length.units = "mm",
vbLinf = 794, vbK = 0.1)

new.dataset@Lc <- 310
new.dataset <- calc_ML(new.dataset)

first.MLZmodel <- ML(new.dataset, 1)
Lc.vec <- seq(240, 340, 5)

sensitivity_Lc(new.dataset, first.MLZmodel, Lc.vec)

}
\references{
Huynh, Q.C, Gedamke, T., Hoenig, J.M, and Porch C. 2017. Multispecies Extensions
to a Nonequilibrium Length-Based Mortality Estimator. Marine and Coastal Fisheries 9:68-78.
}
\seealso{
\code{\link{ML}}
}
