% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{F1_Score}
\alias{F1_Score}
\title{F1 Score}
\usage{
F1_Score(y_true, y_pred, positive = NULL)
}
\arguments{
\item{y_true}{Ground truth (correct) labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}

\item{positive}{An optional character string for the factor level that
corresponds to a "positive" result}
}
\value{
F1 Score
}
\description{
Compute the F1 Score.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
pred <- ifelse(logreg$fitted.values<0.5, 0, 1)
F1_Score(y_true=mtcars$vs, y_pred=pred, positive="0")
F1_Score(y_true=mtcars$vs, y_pred=pred, positive="1")
}

