% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{Gini}
\alias{Gini}
\title{Gini Coefficient}
\usage{
Gini(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) 0-1 labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}
}
\value{
Gini Coefficient
}
\description{
Compute the Gini Coefficient.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
Gini(y_true=mtcars$vs, y_pred=logreg$fitted.values)
}

