% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{Precision}
\alias{Precision}
\title{Precision}
\usage{
Precision(y_true, y_pred, positive = NULL)
}
\arguments{
\item{y_true}{Ground truth (correct) labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}

\item{positive}{An optional character string for the factor level that
corresponds to a "positive" result}
}
\value{
Precision
}
\description{
Compute the precision score.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
pred <- ifelse(logreg$fitted.values<0.5, 0, 1)
Precision(y_true=mtcars$vs, y_pred=pred, positive="0")
Precision(y_true=mtcars$vs, y_pred=pred, positive="1")
}

