% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_evaluation_results}
\alias{table_evaluation_results}
\title{Evaluation Results}
\usage{
table_evaluation_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}

\item{show_table}{Boolean. Whether to show the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with evaluation results.
}
\description{
The \strong{table_evaluation_results()} function provides access to trained model evaluation metrics, automatically
adapting to the type of problem being analyzed. For binary classification problems, it returns a unified
table with performance metrics, while for multiclass classification it generates separate tables for training
and test data, enabling comparative performance evaluation and detection of potential overfitting.
}
\examples{
# Note: For obtaining the evaluation table the user needs to
# complete till fine_tuning( ) function.

\donttest{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Bayesian Optimization")

# And then, you can obtain the evaluation table.

table_results <- table_evaluation_results(wrap_object)

}

}
