% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoAccessibleLinks.R
\name{getCoAccessibleLinks}
\alias{getCoAccessibleLinks}
\title{\code{getCoAccessibleLinks}}
\usage{
getCoAccessibleLinks(
  SampleTileObj,
  cellPopulation = "All",
  regions,
  windowSize = 1 * 10^6,
  numCores = 1,
  ZI = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObj}{The SummarizedExperiment object output from getSampleTileMatrix containing your sample-tile matrices}

\item{cellPopulation}{A string denoting the cell population of interest, which must be present in SampleTileObj}

\item{regions}{a GRanges object or vector or strings containing the regions on which to compute co-accessible links. Strings must be in the format "chr:start-end", e.g. "chr4:1300-2222".
Can be the output from getDifferentialAccessibleTiles.}

\item{windowSize}{the size of the window, in basepairs, around each input region to search for co-accessible links}

\item{numCores}{Optional, the number of cores to use with multiprocessing. Default is 1.}

\item{ZI}{boolean flag that enables zero-inflated (ZI) Spearman correlations to be used. Default is TRUE. If FALSE, skip zero-inflation and calculate the normal Spearman.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
TileCorr A data.table correlation matrix
}
\description{
\code{getCoAccessibleLinks} takes an input set of regions (tiles) and finds co-accessible neighboring regions within a window. Co-accessibility is defined as the correlation between two region intensity (openness) across samples.
}
\details{
The technical details of the zero-inflated correlation can be
         found here:

              Pimentel, Ronald Silva, "Kendall's Tau and Spearman's Rho
              for Zero-Inflated Data" (2009). Dissertations.

         while the implementation (scHOT R package), can be found here:
              http://www.bioconductor.org/packages/release/bioc/html/scHOT.html
}
