% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addServer.R
\name{addServer}
\alias{addServer}
\title{Add New Remote Server to MODIS Inventory}
\usage{
addServer(name, sensor = "MODIS", basepath, varpath, content = "images",
  path_ext = "inst/external", overwrite = FALSE, ...)
}
\arguments{
\item{name}{Character. Name of the remote server that should be added to the 
inventory.}

\item{sensor}{Character. Sensor type, defaults to 'MODIS'.}

\item{basepath}{Character. Absolute online server path.}

\item{varpath}{Character. Pattern of organizational structure on server.}

\item{content}{Character. Content type, defaults to "images".}

\item{path_ext}{Character. Path to folder containing file 
'MODIS_FTPinfo.RData'. When working with RStudio projects (.Rproj), this 
usually defaults to 'inst/external'.}

\item{overwrite}{Logical. If \code{TRUE}, the initial '.RData' file located 
in 'path_ext' will be overwritten.}

\item{...}{Currently not used.}
}
\value{
A 'list' holding the updated contents of 'MODIS_FTPinfo.RData'.
}
\description{
\code{addServer} is a non-exported helper function to add a new entry to the 
list of online (FTP) servers featured by \strong{MODIS} (see 
\code{MODIS:::MODIS_FTPinfo}).
}
\examples{
\dontrun{
## E.g., add server of MODIS evapotranspiration product
MODIS:::addServer(name = "NTSG", sensor = "MODIS",
                  basepath = "ftp://ftp.ntsg.umt.edu/pub/MODIS/NTSG_Products/MOD16/",
                  varpath = "PRODUCT.CCC/YYYY/DDD/")
}                   
    
}
\seealso{
\code{MODIS:::MODIS_FTPinfo}.
}
\author{
Florian Detsch
}
