% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHdf.R
\docType{methods}
\name{getHdf}
\alias{getHdf}
\alias{getHdf,character-method}
\alias{getHdf,missing-method}
\title{Create or Update Local Subset of Online MODIS Data Pool}
\usage{
\S4method{getHdf}{character}(product, HdfName, begin = NULL,
  end = NULL, tileH = NULL, tileV = NULL, extent = NULL,
  collection = NULL, checkIntegrity = TRUE, forceDownload = TRUE,
  ...)

\S4method{getHdf}{missing}(HdfName, checkIntegrity = TRUE, ...)
}
\arguments{
\item{product}{\code{character}. MODIS grid product to be downloaded, see 
\code{\link{getProduct}}. Use dot notation to address Terra and Aqua products 
(e.g. \code{M.D13Q1}).}

\item{HdfName}{\code{character} vector or \code{list}. Full HDF file name(s) 
to download a small set of files. If specified, other file-related parameters 
(i.e., \code{begin}, \code{end}, \code{collection}, etc.) are ignored.}

\item{begin, end}{\code{Date} or \code{character}. Begin and end date of MODIS 
time series, see \code{\link{transDate}}.}

\item{tileH, tileV}{\code{numeric} or \code{character}. Horizontal and 
vertical tile number, see \code{\link{getTile}}.}

\item{extent}{See Details in \code{\link{getTile}}.}

\item{collection}{Desired MODIS product collection as \code{character}, 
\code{integer}, or \code{list} as returned by \code{\link{getCollection}}.}

\item{checkIntegrity}{\code{logical}. If \code{TRUE} (default), the size of 
each downloaded file is checked. In case of inconsistencies, the function 
tries to re-download broken files.}

\item{forceDownload}{\code{logical}. If \code{TRUE} (default), try to 
download data irrespective of whether online information could be retrieved 
via \code{MODIS:::getStruc} or not.}

\item{...}{Further arguments passed to \code{\link{MODISoptions}}, eg 'wait'.}
}
\value{
An invisible vector of downloaded data and paths.
}
\description{
Create or update a local user-defined subset of the global MODIS grid data 
archive. Based on user-specific parameters the function checks in the local 
archive for available data and downloads missing data from the online MODIS 
data pool. When run in a schedule job, the function manage the continuous 
update of the local MODIS data archive.
}
\examples{
\dontrun{
# One or more specific file (no regular erpression allowed here)
a <- getHdf(HdfName = c("MYD11A1.A2009001.h18v04.006.2015363221538.hdf", 
                        "MYD11A1.A2009009.h18v04.006.2015364055036.hdf", 
                        "MYD11A1.A2009017.h18v04.006.2015364115403.hdf"))
a

# Get all MODIS Terra and Aqua M*D11A1 data from 1 December 2016 up to today
# (can be ran in a sceduled job for daily archive update)
b1 <- getHdf(product = "M.D11A1", begin = "2016.12.01", 
             tileH = 18:19, tileV = 4) 
b1               

# Same tiles with a 'list' extent
Austria <- list(xmax = 17.47, xmin = 9.2, ymin = 46.12, ymax = 49.3)
b2 <- getHdf(product = "M.D11A1", begin = "2016336", extent = Austria)
b2

# Using country boarders from 'mapdata' package
c <- getHdf(product = "M.D11A1", begin = "2016306", end = "2016335",
            extent = "Luxembourg")
c             
       
# Interactive selection of spatial extent, see getTile()
d <- getHdf(product = "M.D11A1", begin = "2016306", end = "2016307")
d
}

}
\references{
MODIS data is currently available from the online data pools at 
\itemize{
\item{NASA Land Processes Distributed Active Archive Center (\href{https://lpdaac.usgs.gov/}{LP DAAC})},
\item{Level-1 and Atmosphere Archive & Distribution System (\href{https://ladsweb.modaps.eosdis.nasa.gov/}{LAADS})}, and
\item{National Snow & Ice Data Center (\href{https://nsidc.org/}{NSIDC})}.
}
}
\author{
Matteo Mattiuzzi
}
