% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_download.R
\name{MODIStsp_download}
\alias{MODIStsp_download}
\title{MODIStsp download function}
\usage{
MODIStsp_download(modislist, out_folder_mod, download_server, http,
  n_retries, use_aria, date_dir, year, DOY, user, password, sens_sel,
  date_name, gui, mess_lab, verbose)
}
\arguments{
\item{modislist}{\code{character array} List of MODIS images to be downloaded for
the selected date (as returned from \code{get_mod_filenames}). Can be a single
image, or a list of images in case different tiles are needed!}

\item{out_folder_mod}{\code{character} Folder where the hdfs are to be stored}

\item{download_server}{\code{character ["http"]} Server to be used.}

\item{http}{\code{character} Address of the http server for the selected product.}

\item{n_retries}{\code{numeric} Max number of retry attempts on download. If
download fails more that n_retries times consecutively, abort}

\item{use_aria}{\code{logical} If TRUE, aria2c is used to accelerate download
(if available !).}

\item{date_dir}{\code{character array} Sub-folder where the different images
can be found (element of the list returned from \code{get_mod_dirs}, used in case
of http download to generate the download addresses).}

\item{year}{\code{character} Acquisition year of the images to be downloaded}

\item{DOY}{\code{character array} Acquisition doys of the images to be downloaded}

\item{user}{\code{character} Username for http download}

\item{password}{\code{character} Password for http download}

\item{sens_sel}{\code{character ["terra" | "aqua"]} Selected sensor.}

\item{date_name}{\code{character} Date of acquisition of the images to be downloaded.}

\item{gui}{\code{logical} Indicates if on an interactive or non-interactive execution
(only influences where the log messages are sent).}

\item{mess_lab}{pointer to the gWidget used to issue processing messages in
when gui = TRUE.}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}
}
\value{
The function is called for its side effects
}
\description{
Internal function dealing with download of MODIS hdfs from
http remote server for a given date.
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
