% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_variation.R
\name{perform_variation}
\alias{perform_variation}
\title{Run variation operators}
\usage{
perform_variation(variation, X, iter, ...)
}
\arguments{
\item{variation}{List vector containing the variation operators to be used.
See \code{\link[=moead]{moead()}} for details.}

\item{X}{Population matrix of the MOEA/D (each row is a candidate solution).}

\item{iter}{iterations counter of the \code{\link[=moead]{moead()}} function.}

\item{...}{other parameters to be passed down to the individual variation
operators (see documentation of the specific \code{variation_}\strong{xyz}\code{()}
functions for details)}
}
\value{
List object containing a modified population matrix \code{X}, a
local search argument list \code{ls.arg}, and the number of function evaluations
used by the variation operators, \code{var.nfe}.
}
\description{
Sequentially apply variation operators for the MOEADr package
}
\details{
This routine performs the variation block for the MOEA/D. The
list of available variation operators can be generated using
\code{\link[=get_variation_operators]{get_variation_operators()}}.

If the \code{localsearch} operator is included, it is executed whenever its
conditions (period of occurrence or probability of occurrence) are verified.
See \code{\link[=variation_localsearch]{variation_localsearch()}} for details.
}
