% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.single.t.t.R
\name{d.single.t.t}
\alias{d.single.t.t}
\title{d for Single t from t}
\usage{
d.single.t.t(t, n, a = 0.05)
}
\arguments{
\item{t}{t-test value}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
The effect size (Cohen's d) with associated confidence intervals
and relevant statistics.

\item{d}{effect size}
\item{dlow}{lower level confidence interval d value}
\item{dhigh}{upper level confidence interval d value}
\item{n}{sample size}
\item{df}{degrees of freedom (sample size - 1)}
\item{t}{sig stats}
\item{p}{p-value}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the t-statistic in APA style for markdown printing}
}
\description{
This function displays d and non-central confidence interval for single t
estimated from the t-statistic.
}
\details{
To calculate d, the t-statistic is divided by the square root of the sample size.

d = t / sqrt(n)

\href{https://www.aggieerin.com/shiny-server/tests/singlett.html}{Learn more on our example page.}
}
\examples{

#A school has a gifted/honors program that they claim is
#significantly better than others in the country. The gifted/honors
#students in this school scored an average of 1370 on the SAT,
#with a standard deviation of 112.7, while the national average
#for gifted programs is a SAT score of 1080.

    gift = t.test(singt_data, mu = 1080, alternative = "two.sided")

#According to a single-sample t-test, the scores of the students
#from the program were significantly higher than the national
#average, t(14) = 9.97, p < .001.

#You can type in the numbers directly as shown below, or refer
#to your dataset within the function.

    d.single.t.t(t = 9.968, n = 15, a = .05)

    d.single.t.t(9.968, 15, .05)

    d.single.t.t(gift$statistic, length(singt_data$SATscore), .05)
}
\keyword{effect}
\keyword{single}
\keyword{size,}
\keyword{t}
