% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.correl.R
\name{r.correl}
\alias{r.correl}
\title{r to Coefficient of Determination (R2) from F}
\usage{
r.correl(r, n, a = 0.05)
}
\arguments{
\item{r}{correlation coefficient}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
Provides correlation coefficient and coefficient of
determination with associated confidence intervals
and relevant statistics.

\item{r}{correlation coefficient}
\item{rlow}{lower level confidence interval r}
\item{rhigh}{upper level confidence interval r}
\item{R2}{coefficient of determination}
\item{R2low}{lower level confidence interval of R2}
\item{R2high}{upper level confidence interval of R2}
\item{se}{standard error}
\item{n}{sample size}
\item{dfm}{degrees of freedom of mean}
\item{dfe}{degrees of freedom of error}
\item{t}{t-statistic}
\item{F}{F-statistic}
\item{p}{p-value}
\item{estimate}{the r statistic and confidence interval in
APA style for markdown printing}
\item{estimateR2}{the R^2 statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the t-statistic in APA style for markdown printing}
}
\description{
This function displays transformation from r to r2 to calculate
the non-central confidence interval for r2 using the F distribution.
}
\details{
The t-statistic is calculated by first dividing one minus the
square root of r squared by degrees of freedom of the error.
r is divided by this value.

t = r / sqrt((1 - rsq) / (n - 2))

The F-statistic is the t-statistic squared.

Fvalue = t ^ 2

\href{https://www.aggieerin.com/shiny-server/tests/rcorrel.html}{Learn more on our example page.}
}
\examples{

#This example is derived from the mtcars dataset provided in R.

#What is the correlation between miles per gallon and car weight?

cor.test(mtcars$mpg, mtcars$wt)

r.correl(r = -0.8676594, n = 32, a = .05)
}
\keyword{correlation}
\keyword{effect}
\keyword{size,}
