% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{invl}
\alias{invl}
\title{invl calculates growth increments for the inverse logistic}
\usage{
invl(par, indat, initL = "l1", delT = "dt")
}
\arguments{
\item{par}{a vector of at least Linf, and K from teh von Bertalanffy 
growth curve}

\item{indat}{the matrix or data.frame of data columns containing at
least the initial lengths and the deltaT, time intervals between
tag release and recapture.}

\item{initL}{column name of the initial lengths within indat, 
default="l1"}

\item{delT}{column name of the time interval, deltaT, within indat, 
default="dt"}
}
\value{
a vector of predicted growth increments
}
\description{
invl requires at least three parameters, MaxDL, L50, and
    delta, in a vector, as well as the initial length and the change 
    in time between tag release and recapture. Given those it 
    calculates the expected growth increment according to the inverse
    logistic curve. The parameter delta is equivalent to L95 - L50, 
    the length difference between the length at half MaxDL, and the
    length at 5% of MaxDL.
}
\examples{
 data(blackisland)
 oldpar <- par(no.readonly=TRUE)
 plot(blackisland$l1,blackisland$dl,type="p",pch=16,
 xlab="Initial Length mm",ylab="Growth Increment mm",panel.first=grid())
 abline(h=0)
 param <- c(25, 130, 35, 3) # MaxDL, L50, delta, sigma
 predDL <- invl(param,blackisland,initL="l1",delT="dt")
 lines(blackisland$l1,predDL,col=2,lwd=2) 
 par(oldpar)
}
\references{
Haddon, M., Mundy, C., and D. Tarbath (2008) Using an 
   inverse-logistic model to describe growth increments of blacklip 
   abalone (Haliotis rubra) in Tasmania. \emph{Fishery Bulletin} 
   106:58-71
}
