% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotExpectAvail.R
\name{plotExpectAvail}
\alias{plotExpectAvail}
\title{plot the graph for the expected availability}
\usage{
plotExpectAvail(days, occ_per_day, tau_shape, tau_mean, tau_initial,
  tau_quadratic_max)
}
\arguments{
\item{days}{Duration of the study.}

\item{occ_per_day}{Number of decision time points per day.}

\item{tau_shape}{The pattern for expected availability, choices are constant, linear or quadratic.
Note:
\enumerate{
            \item{Constant} The expected availability stays constant over the study.
            \item{Linear} A linearly increasing pattern of expected availability might be used if
            participants will find the intervention useful and thus more likely to turn the
            intervention on. A linearly decreasing pattern of expected availability might be used
            if participants learn more about the intervetion and get bored through the course of
            the study and thus getting less likely to turn on the invervention.
            \item{Quadratic} A quadratic pattern of availability. Here the changing point of
            availability refers to day of either maximal of minimal availability, depending on the
            input values of initial and average availability.
}}

\item{tau_mean}{Average of expected availability.}

\item{tau_initial}{Initial Value of expected availability when tau_shape is linear or quadratic.}

\item{tau_quadratic_max}{Changing point of availability when tau_shape is quadratic.}
}
\value{
A graph for expected availability.
}
\description{
plot of the graphs for the expected availability, i.e., the expected
probability that a participant is available to receive treatment at a decision time.
when the pattern for the expected availability is constant, linear or quadractic.
}
\examples{
   plotExpectAvail(days=42,
                   occ_per_day=5,
                   tau_shape="quadratic",
                   tau_mean=0.5,
                   tau_initial=0.7,
                   tau_quadratic_max=42)


}

