% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiD.r
\name{did}
\alias{did}
\title{Difference-in-difference estimator based on SCM}
\usage{
did(x, what, range.pre, range.post, alternative = c("two.sided", "less",
  "greater"), exclude.ratio = Inf)
}
\arguments{
\item{x}{An object of class \code{"mscmt"}, usually obtained as
the result of a call to function \code{\link{mscmt}}.}

\item{what}{A character vector. Name of the variable to be considered. If 
missing, the (first) dependent variable will be used.}

\item{range.pre}{A vector of length 2 defining the range of the pre-treatment
period with start and end time given as 
\itemize{
\item annual dates, if the format of start/end time is "dddd", e.g. "2016",
\item quarterly dates, if the format of start/end time is "ddddQd", e.g. 
"2016Q1",
\item monthly dates, if the format of start/end time is "dddd?dd", e.g. 
"2016/03" or "2016-10",
}
corresponding to the format of the respective column of the \code{times.dep}
argument of \code{\link{mscmt}}.
If missing, the corresponding column of \code{times.dep} will be used.}

\item{range.post}{A vector of length 2 defining the range of the 
post-treatment period with start and end time given as 
\itemize{
\item annual dates, if the format of start/end time is "dddd", e.g. "2016",
\item quarterly dates, if the format of start/end time is "ddddQd", e.g. 
"2016Q1",
\item monthly dates, if the format of start/end time is "dddd?dd", e.g. 
"2016/03" or "2016-10",
}
corresponding to the format of the respective column of the \code{times.dep}
argument of \code{\link{mscmt}}. Will be guessed if missing.}

\item{alternative}{A character string giving the alternative of the test. 
Either \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.}

\item{exclude.ratio}{A numerical scalar (default: \code{Inf}). When 
calculating the p-value, control units with an average pre-treatment gap
of more then \code{exclude.ratio} times the average pre-treatment gap of
the treated unit are excluded from the analysis.}
}
\value{
A list with components \code{effect.size}, \code{average.pre} and
\code{average.post}. If \code{x} contains the results of a placebo study,
three components \code{p.value}, \code{rank}, and \code{excluded} (with the 
names of the excluded units) are included additionally.
}
\description{
\code{did} calculates difference-in-difference estimators based on SCM.
}
\details{
\code{did} calculates difference-in-difference estimators with corresponding
p-values (if results of a placebo study are present) based on the Synthetic 
Control Method.
}
\examples{
\dontrun{
## for an example, see the main package vignette:
 vignette("WorkingWithMSCMT",package="MSCMT")
}
}

