% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ancillary_Indicators.R
\name{plot_crosscorr}
\alias{plot_crosscorr}
\title{Produce a cross-correlation plot of the derived data arising from getinds(MSE_object)}
\usage{
plot_crosscorr(indPPD, indData, pp = 1, dnam = c("CS", "CV", "CM", "IS",
  "MLS"), res = 1)
}
\arguments{
\item{indPPD}{A 3D array of results arising from running getind on an MSE of the Null operating model (type of data/stat (e.g. mean catches),time period (chunk), simulation)}

\item{indData}{A 3D array of results arising from running getind on an MSE of the Alternative operating model (type of data/stat (e.g. mean catches),time period (chunk), simulation)}

\item{pp}{Positive integer, the number of time chunks (blocks of years normally, second dimension of indPPD and indData) to produce the plot for.}

\item{dnam}{A character vector of names of the data for plotting purposes (as long as dimension 1 of indPPD and indData).}

\item{res}{The size of the temporal blocking that greated indPPD and indData - this is just used for labelling purposes}
}
\value{
A cross-correlation plot (ndata-1) x (ndata-1)
}
\description{
Produce a cross-correlation plot of the derived data arising from getinds(MSE_object)
}
\references{
Carruthers and Hordyk 2018
}
\author{
T. Carruthers
}
