## ----set options, echo = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")
knitr::opts_chunk$set(dpi=85)
options(width = 650)

## ---- echo = FALSE, message = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(MSEtool)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DLMtool::userguide()

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DD_result <- DD_TMB(Data = Red_snapper, ...)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  class?Assessment

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  vignette("Assessment", package = "MSEtool")

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  summary(DD_result)
#  plot(DD_result, save_figure = TRUE, save_dir = tempdir()) # By default, also saves figures in a temporary directory for viewing through a HTML browser. The directory can be changed to a user's filespace of choice.

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  retrospective(DD_result, nyr = 5) # Retrospective analysis going back 5 years from current year
#  profile(DD_result, R0 = seq(0.75, 1.25, 0.025), h = seq(0.95, 1, 2.5e-3)) # Joint profile over grid of R0 and steepness

## ---- echo = FALSE, fig.width = 5, fig.height = 4-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
par(mar = c(5,5,3,1))
Brel <- seq(0, 1, length.out = 200)
plot(Brel, MSEtool::HCRlin(Brel, 0.1, 0.4), xlab = expression(Estimated~~SSB/SSB[0]), ylab = "TAC adjustment factor \n(proportion of FMSY catch)", main = "40-10 harvest control rule", type = "l", col = "blue")
abline(v = c(0.1, 0.4), col = "red", lty = 2)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
avail("MP", all_avail = FALSE)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DD_MSY <- make_MP(DD_TMB, HCR_MSY, ...)
#  DD_4010 <- make_MP(DD_TMB, HCR40_10)
#  myMSE <- DLMtool::runMSE(OM = DLMtool::testOM, MPs = c("FMSYref", "DD_MSY", "DD_4010"))
#  Tplot2(myMSE)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DD_MSY_Ricker_fixsteep <- make_MP(DD_TMB, HCR_MSY, SR = "Ricker", fix_h = TRUE)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  prelim_AM(DLMtool::testOM, DD_TMB, ...)
#  #> Generating Hist object from OM object via runMSE:
#  #> Loading operating model
#  #> Optimizing for user-specified movement
#  #> Optimizing for user-specified depletion
#  #> Calculating historical stock and fishing dynamics
#  #> Calculating MSY reference points
#  #> Calculating B-low reference points
#  #> Calculating reference yield - best fixed F strategy
#  #> Returning historical simulations
#  #> Running DD_TMB with 48 simulations for DLMtool::testOM.
#  #> Assessments complete.
#  #> Total time to run 48 assessments: 1.2 seconds
#  #> 2 of 48 simulations (4.2%) did not converge.
#  #> See simulation number: 11 21

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DD_MSY <- make_MP(DD_TMB, HCR_MSY, diagnostic = "full")
#  myMSE <- runMSE(..., MPs = "DD_MSY", PPD = TRUE)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  diagnostic_AM(myMSE)
#  retrospective_AM(myMSE, sim = 1, MP = "DD_MSY")

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DD_MSY <- make_MP(DD_TMB, HCR_MSY)
#  DD_4010 <- make_MP(DD_TMB, HCR40_10)
#  snapper_TAC <- TAC(Red_snapper, MPs = c("DD_MSY", "DD_4010"))
#  plot(snapper_TAC)

