#include "SingleRegime.h"
#include "sARCH.h"
#include "Normal.h"
#include "Ged.h"
#include "Student.h"
#include "Symmetric.h"
#include "Skewed.h"
//===========================================================================//
//===========================================================================//
//================================== sARCH ==================================//
//===========================================================================//
//===========================================================================//

typedef SingleRegime<sARCH<Symmetric<Normal> > > sARCH_norm;
typedef SingleRegime<sARCH<Skewed<Normal> > > sARCH_snorm;
typedef SingleRegime<sARCH<Symmetric<Student> > > sARCH_std;
typedef SingleRegime<sARCH<Skewed<Student> > > sARCH_sstd;
typedef SingleRegime<sARCH<Symmetric<Ged> > > sARCH_ged;
typedef SingleRegime<sARCH<Skewed<Ged> > > sARCH_sged;

RCPP_MODULE(sARCH) {
  // sARCH-norm-symmetric
  class_<sARCH_norm>("sARCH_norm")
      .constructor()
      .field("name", &sARCH_norm::name)
      .field("theta0", &sARCH_norm::theta0)
      .field("Sigma0", &sARCH_norm::Sigma0)
      .field("label", &sARCH_norm::label)
      .field("lower", &sARCH_norm::lower)
      .field("upper", &sARCH_norm::upper)
      .field("ineq_lb", &sARCH_norm::ineq_lb)
      .field("ineq_ub", &sARCH_norm::ineq_ub)
      .field("NbParams", &sARCH_norm::NbParams)
      .field("NbParamsModel", &sARCH_norm::NbParamsModel)
      .method("f_sim", &sARCH_norm::f_sim)
      .method("f_pdf", &sARCH_norm::f_pdf)
      .method("f_pdf_its", &sARCH_norm::f_pdf_its)
      .method("f_cdf", &sARCH_norm::f_cdf)
      .method("f_cdf_its", &sARCH_norm::f_cdf_its)
      .method("f_simAhead", &sARCH_norm::f_simAhead)
      .method("f_get_sd", &sARCH_norm::get_sd)
      .method("f_set_sd", &sARCH_norm::set_sd)
      .method("f_get_mean", &sARCH_norm::get_mean)
      .method("f_set_mean", &sARCH_norm::set_mean)
      .method("f_rnd", &sARCH_norm::f_rnd)
      .method("calc_ht", &sARCH_norm::calc_ht)
      .method("eval_model", &sARCH_norm::eval_model)
      .method("ineq_func", &sARCH_norm::ineq_func)
      .method("f_unc_vol", &sARCH_norm::f_unc_vol);
  // sARCH-std-symmetric
  class_<sARCH_std>("sARCH_std")
      .constructor()
      .field("name", &sARCH_std::name)
      .field("theta0", &sARCH_std::theta0)
      .field("Sigma0", &sARCH_std::Sigma0)
      .field("label", &sARCH_std::label)
      .field("lower", &sARCH_std::lower)
      .field("upper", &sARCH_std::upper)
      .field("ineq_lb", &sARCH_std::ineq_lb)
      .field("ineq_ub", &sARCH_std::ineq_ub)
      .field("NbParams", &sARCH_std::NbParams)
      .field("NbParamsModel", &sARCH_std::NbParamsModel)
      .method("f_sim", &sARCH_std::f_sim)
      .method("f_pdf", &sARCH_std::f_pdf)
      .method("f_pdf_its", &sARCH_std::f_pdf_its)
      .method("f_cdf", &sARCH_std::f_cdf)
      .method("f_cdf_its", &sARCH_std::f_cdf_its)
      .method("f_simAhead", &sARCH_std::f_simAhead)
      .method("f_get_sd", &sARCH_std::get_sd)
      .method("f_set_sd", &sARCH_std::set_sd)
      .method("f_get_mean", &sARCH_std::get_mean)
      .method("f_set_mean", &sARCH_std::set_mean)
      .method("f_rnd", &sARCH_std::f_rnd)
      .method("calc_ht", &sARCH_std::calc_ht)
      .method("eval_model", &sARCH_std::eval_model)
      .method("ineq_func", &sARCH_std::ineq_func)
      .method("f_unc_vol", &sARCH_std::f_unc_vol);
  // sARCH-ged-symmetric
  class_<sARCH_ged>("sARCH_ged")
      .constructor()
      .field("name", &sARCH_ged::name)
      .field("theta0", &sARCH_ged::theta0)
      .field("Sigma0", &sARCH_ged::Sigma0)
      .field("label", &sARCH_ged::label)
      .field("lower", &sARCH_ged::lower)
      .field("upper", &sARCH_ged::upper)
      .field("ineq_lb", &sARCH_ged::ineq_lb)
      .field("ineq_ub", &sARCH_ged::ineq_ub)
      .field("NbParams", &sARCH_ged::NbParams)
      .field("NbParamsModel", &sARCH_ged::NbParamsModel)
      .method("f_sim", &sARCH_ged::f_sim)
      .method("f_pdf", &sARCH_ged::f_pdf)
      .method("f_pdf_its", &sARCH_ged::f_pdf_its)
      .method("f_cdf", &sARCH_ged::f_cdf)
      .method("f_cdf_its", &sARCH_ged::f_cdf_its)
      .method("f_simAhead", &sARCH_ged::f_simAhead)
      .method("f_get_sd", &sARCH_ged::get_sd)
      .method("f_set_sd", &sARCH_ged::set_sd)
      .method("f_get_mean", &sARCH_ged::get_mean)
      .method("f_set_mean", &sARCH_ged::set_mean)
      .method("f_rnd", &sARCH_ged::f_rnd)
      .method("calc_ht", &sARCH_ged::calc_ht)
      .method("eval_model", &sARCH_ged::eval_model)
      .method("ineq_func", &sARCH_ged::ineq_func)
      .method("f_unc_vol", &sARCH_ged::f_unc_vol);

  // sARCH-norm-skew
  class_<sARCH_snorm>("sARCH_snorm")
      .constructor()
      .field("name", &sARCH_snorm::name)
      .field("theta0", &sARCH_snorm::theta0)
      .field("Sigma0", &sARCH_snorm::Sigma0)
      .field("label", &sARCH_snorm::label)
      .field("lower", &sARCH_snorm::lower)
      .field("upper", &sARCH_snorm::upper)
      .field("ineq_lb", &sARCH_snorm::ineq_lb)
      .field("ineq_ub", &sARCH_snorm::ineq_ub)
      .field("NbParams", &sARCH_snorm::NbParams)
      .field("NbParamsModel", &sARCH_snorm::NbParamsModel)
      .method("f_sim", &sARCH_snorm::f_sim)
      .method("f_pdf", &sARCH_snorm::f_pdf)
      .method("f_pdf_its", &sARCH_snorm::f_pdf_its)
      .method("f_cdf", &sARCH_snorm::f_cdf)
      .method("f_cdf_its", &sARCH_snorm::f_cdf_its)
      .method("f_simAhead", &sARCH_snorm::f_simAhead)
      .method("f_get_sd", &sARCH_snorm::get_sd)
      .method("f_set_sd", &sARCH_snorm::set_sd)
      .method("f_get_mean", &sARCH_snorm::get_mean)
      .method("f_set_mean", &sARCH_snorm::set_mean)
      .method("f_rnd", &sARCH_snorm::f_rnd)
      .method("calc_ht", &sARCH_snorm::calc_ht)
      .method("eval_model", &sARCH_snorm::eval_model)
      .method("ineq_func", &sARCH_snorm::ineq_func)
      .method("f_unc_vol", &sARCH_snorm::f_unc_vol);
  // sARCH-std-skew
  class_<sARCH_sstd>("sARCH_sstd")
      .constructor()
      .field("name", &sARCH_sstd::name)
      .field("theta0", &sARCH_sstd::theta0)
      .field("Sigma0", &sARCH_sstd::Sigma0)
      .field("label", &sARCH_sstd::label)
      .field("lower", &sARCH_sstd::lower)
      .field("upper", &sARCH_sstd::upper)
      .field("ineq_lb", &sARCH_sstd::ineq_lb)
      .field("ineq_ub", &sARCH_sstd::ineq_ub)
      .field("NbParams", &sARCH_sstd::NbParams)
      .field("NbParamsModel", &sARCH_sstd::NbParamsModel)
      .method("f_sim", &sARCH_sstd::f_sim)
      .method("f_pdf", &sARCH_sstd::f_pdf)
      .method("f_pdf_its", &sARCH_sstd::f_pdf_its)
      .method("f_cdf", &sARCH_sstd::f_cdf)
      .method("f_cdf_its", &sARCH_sstd::f_cdf_its)
      .method("f_simAhead", &sARCH_sstd::f_simAhead)
      .method("f_get_sd", &sARCH_sstd::get_sd)
      .method("f_set_sd", &sARCH_sstd::set_sd)
      .method("f_get_mean", &sARCH_sstd::get_mean)
      .method("f_set_mean", &sARCH_sstd::set_mean)
      .method("f_rnd", &sARCH_sstd::f_rnd)
      .method("calc_ht", &sARCH_sstd::calc_ht)
      .method("eval_model", &sARCH_sstd::eval_model)
      .method("ineq_func", &sARCH_sstd::ineq_func)
      .method("f_unc_vol", &sARCH_sstd::f_unc_vol);
  // sARCH-ged-skew
  class_<sARCH_sged>("sARCH_sged")
      .constructor()
      .field("name", &sARCH_sged::name)
      .field("theta0", &sARCH_sged::theta0)
      .field("Sigma0", &sARCH_sged::Sigma0)
      .field("label", &sARCH_sged::label)
      .field("lower", &sARCH_sged::lower)
      .field("upper", &sARCH_sged::upper)
      .field("ineq_lb", &sARCH_sged::ineq_lb)
      .field("ineq_ub", &sARCH_sged::ineq_ub)
      .field("NbParams", &sARCH_sged::NbParams)
      .field("NbParamsModel", &sARCH_sged::NbParamsModel)
      .method("f_sim", &sARCH_sged::f_sim)
      .method("f_pdf", &sARCH_sged::f_pdf)
      .method("f_pdf_its", &sARCH_sged::f_pdf_its)
      .method("f_cdf", &sARCH_sged::f_cdf)
      .method("f_cdf_its", &sARCH_sged::f_cdf_its)
      .method("f_simAhead", &sARCH_sged::f_simAhead)
      .method("f_get_sd", &sARCH_sged::get_sd)
      .method("f_set_sd", &sARCH_sged::set_sd)
      .method("f_get_mean", &sARCH_sged::get_mean)
      .method("f_set_mean", &sARCH_sged::set_mean)
      .method("f_rnd", &sARCH_sged::f_rnd)
      .method("calc_ht", &sARCH_sged::calc_ht)
      .method("eval_model", &sARCH_sged::eval_model)
      .method("ineq_func", &sARCH_sged::ineq_func)
      .method("f_unc_vol", &sARCH_sged::f_unc_vol);
}
