% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_HLRTest.R
\name{HLRTest}
\alias{HLRTest}
\title{Hansen (1992) likelihood ratio test}
\usage{
HLRTest(Y, p, control = list())
}
\arguments{
\item{Y}{A (\code{T x 1}) matrix of observations.}

\item{p}{Integer determining the number of autoregressive lags.}

\item{control}{List with test procedure options including: 
\itemize{
  \item{\code{ix}: }{List of Markov Switching parameters. 1 = just mean c(1,2) = mean and first param, (default: 1).}
  \item{\code{msvar}: }{Boolean indicator. If \code{TRUE}, there is a switch in variance. If \code{FALSE} only switch in mean is considered. Default is \code{FALSE}.}
  \item{\code{qbound}: }{Indicator that bounds q by 1-p (default: \code{FALSE}).}
  \item{\code{gridsize}: }{Integer determining the number of grid points for markov switching parameters. Default is \code{20}.}
  \item{\code{p_gridsize}: }{Integer determining the number of grid points for transition probabilities. Default is \code{12}.}
  \item{\code{p_stepsize}: }{Double determining the step size for grid points of transition probabilities. This, along with \code{p_gridsize} will determine the bounds of search space. Default is \code{0.075}.}
  \item{\code{mugrid_from}: }{Double determining the minimum value of mean in second regime. Default is \code{0.1}.}
  \item{\code{mugrid_by}: }{Double determining the step size for grid points of mean in second regime. This, along with \code{gridsize} will determine the max value of mean in second regime. Default is \code{0.1}.}
  \item{\code{siggrid_from}: }{Double determining the minimum value of sigma in second regime (if \code{msvar = TRUE}). Default is \code{0.1}.}
  \item{\code{siggrid_by}: }{Double determining the step size for grid points of sigma in second regime. This, along with \code{gridsize} will determine the max value of sigma in second regime. Default is \code{0.1}.}
  \item{\code{N}: }{Integer determining the number of replications. Default is \code{1000}.}
  \item{\code{nwband}: }{Integer determining maximum bandwidth in Bartlett kernel. Critical values and p-values are returned for each bandwidth from \code{0:nwband} as suggested in Hansen (1996). Default is \code{4}.}
  \item{\code{sig_min}: }{Double determining minimum value of sigma in first regime that will be used in non-linear optimization with fixed value of sigma in second regime. This is used to avoid negative variances. Default is \code{0.01}.}
}}
}
\value{
List of class \code{HLRTest} (\code{S3} object) with model attributes including: 
\itemize{
  \item{\code{mdl_h0}: }{List with restricted model attributes. This will be of class \code{ARmdl} (\code{S3} object). See \code{\link{ARmdl}}.}
  \item{\code{LR0}: }{Likelihood ratio test statistic value.}
  \item{\code{LRN}: }{A (\code{N x 1}) vector with simulated LRT statistics under null hypothesis.}
  \item{\code{pval}: }{P-value.}
  \item{\code{LR_cv}: }{A (\code{nwband x 3}) matrix with 90\%, 95\%, and 99\% critical values in each column respectively.}
  \item{\code{coef}: }{Vector of coefficients from restricted model and grid search that maximized standardized LRT. }
  \item{\code{control}: }{List with test procedure options used.}
}
}
\description{
This function performs Hansen's likelihood ratio test as described in Hansen (1992).
Original source code can be found \href{https://www.ssc.wisc.edu/~bhansen/progs/jae_92.html}{here}.
}
\references{
Hansen, Bruce E. 1992. “The likelihood ratio test under nonstandard conditions: testing the Markov switching model of GNP.” \emph{Journal of applied Econometrics} 7 (S1): S61–S82.

Hansen, Bruce E. 1996. “Erratum: The likelihood ratio test under nonstandard conditions: testing the Markov switching model of GNP.” \emph{Journal of applied Econometrics} 7 (S1): S61–S82.
}
