% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune}
\alias{tune}
\alias{tune.formula}
\alias{tune.matrix}
\alias{tune.ModelFrame}
\alias{tune.recipe}
\title{Model Tuning and Selection}
\usage{
tune(x, ...)

\method{tune}{formula}(x, data, models, grid = 3, fixed = NULL,
  control = CVControl, metrics = NULL, stat = base::mean,
  maximize = TRUE, ...)

\method{tune}{matrix}(x, y, models, grid = 3, fixed = NULL,
  control = CVControl, metrics = NULL, stat = base::mean,
  maximize = TRUE, ...)

\method{tune}{ModelFrame}(x, models, grid = 3, fixed = NULL,
  control = CVControl, metrics = NULL, stat = base::mean,
  maximize = TRUE, ...)

\method{tune}{recipe}(x, models, grid = 3, fixed = NULL,
  control = CVControl, metrics = NULL, stat = base::mean,
  maximize = TRUE, ...)
}
\arguments{
\item{x}{defines a relationship between model predictor and response
variables.  May be a \code{formula}, design matrix of predictors,
\code{ModelFrame}, or untrained \code{recipe}.}

\item{...}{arguments passed to the \code{metrics} functions.}

\item{data}{\code{data.frame} containing observed predictors and outcomes.}

\item{models}{\code{MLModel} function, function name, object or list of the
aforementioned elements, such as that returned by \code{\link{expand.model}}.}

\item{grid}{\code{data.frame} containing parameter values at which to
evaluate a single model supplied to \code{models}, the number of
parameter-specific values to generate automatically if the model has a
pre-defined grid, or a call to \code{\link{Grid}}.  Ignored in the case of a
list of models.}

\item{fixed}{list of fixed parameter values to combine with those in
\code{grid}.}

\item{control}{\code{\link{MLControl}} object, control function, or character
string naming a control function defining the resampling method to be
employed.}

\item{metrics}{function, one or more function names, or list of named
functions to include in the calculation of performance metrics.  The default
\code{\link{performance}} metrics are used unless otherwise specified.  Model
selection is based on the first specified metric.}

\item{stat}{function to compute a summary statistic on resampled values of
the metric for model selection.}

\item{maximize}{logical indicating whether to select the model having the
maximum or minimum value of the performance metric.  Set automatically if a
package \code{\link{metrics}} function is explicitly specified for the model
selection.}

\item{y}{predictor variable.}
}
\value{
\code{MLModelTune} class object that inherits from \code{MLModel}.
}
\description{
Evaluate a model over a grid of tuning parameters or a list of specified
models and select the best one according to resample estimation of predictive
performance.
}
\examples{
\donttest{
## Numeric response example
fo <- sale_amount ~ .

# User-specified grid
(gbmtune1 <- tune(fo, data = ICHomes, model = GBMModel,
                  grid = expand.grid(n.trees = c(25, 50, 100),
                                     interaction.depth = 1:3,
                                     n.minobsinnode = c(5, 10)),
                  control = CVControl(folds = 10, repeats = 5)))

# Automatically generated grid
(gbmtune2 <- tune(fo, data = ICHomes, model = GBMModel, grid = 3,
                  control = CVControl(folds = 10, repeats = 5)))

# Randomly sampled grid points
(gbmtune3 <- tune(fo, data = ICHomes, model = GBMModel,
                  grid = Grid(length = 1000, random = 10),
                  control = CVControl(folds = 10, repeats = 5)))

summary(gbmtune3)
plot(gbmtune3, type = "line")

gbmfit <- fit(fo, data = ICHomes, model = gbmtune3)
varimp(gbmfit)
}

}
\seealso{
\code{\link{ModelFrame}}, \code{\link[recipes]{recipe}},
\code{\link{modelinfo}}, \code{\link{expand.model}}, \code{\link{Grid}},
\code{\link{MLControl}}, \code{\link{fit}}, \code{\link{plot}},
\code{\link{summary}}
}
