% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModeledInput.R
\name{ModeledInput}
\alias{ModeledInput}
\alias{ModeledFrame}
\alias{ModeledRecipe}
\alias{ModeledInput.formula}
\alias{ModeledInput.matrix}
\alias{ModeledInput.ModelFrame}
\alias{ModeledInput.recipe}
\alias{ModeledInput.MLModel}
\alias{ModeledInput.MLModelFunction}
\title{ModeledInput Classes}
\usage{
ModeledInput(x, ...)

\method{ModeledInput}{formula}(x, data, model, ...)

\method{ModeledInput}{matrix}(x, y, model, ...)

\method{ModeledInput}{ModelFrame}(x, model, ...)

\method{ModeledInput}{recipe}(x, model, ...)

\method{ModeledInput}{MLModel}(x, ...)

\method{ModeledInput}{MLModelFunction}(x, ...)
}
\arguments{
\item{x}{\link[=inputs]{input} specifying a relationship between model
predictor and response variables.  Alternatively, a \link[=models]{model}
function or object may be given first followed by the input specification.}

\item{...}{arguments passed to other methods.}

\item{data}{\link[=data.frame]{data frame} or an object that can be converted
to one.}

\item{model}{\link[=models]{model} function, function name, or object.}

\item{y}{response variable.}
}
\value{
\code{ModeledFrame} or \code{ModeledRecipe} class object that
inherits from \code{ModelFrame} or \code{recipe}.
}
\description{
Class for storing a model input and specification pair for \pkg{MachineShop}
model fitting.
}
\examples{
## Modeled model frame
mod_mf <- ModeledInput(sale_amount ~ ., data = ICHomes, model = GLMModel)
fit(mod_mf)

## Modeled recipe
library(recipes)

rec <- recipe(sale_amount ~ ., data = ICHomes)
mod_rec <- ModeledInput(rec, model = GLMModel)
fit(mod_rec)

}
\seealso{
\code{\link{fit}}, \code{\link{resample}},
\code{\link{SelectedInput}}
}
