\name{estimateEffects}
\alias{estimateEffects}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Estimate Effects on the Frontier
}
\description{
  \code{estimateEffects()} is used to estimate the effect of the
    treatment along the entire frontier. 
}
\usage{
estimateEffects(frontier.object, formula, prop.estimated = 1,
                mod.dependence.formula, continuous.vars = NA,
                seed = 1, means.as.cutpoints = FALSE)
}
\arguments{
  \item{frontier.object}{
    An object generated by \code{makeFrontier()}.
  }
  \item{formula}{
    An object of class formula (or one that can be
    coerced to that class). This will be passed to
    \code{lm()} to estimate the point estimates for
    the causal effect estimates across the frontier.
  }
  \item{prop.estimated}{
    The proportion of points on the frontier to estimate.
    By default, 100\% of the points on the frontier are
    estimated. To estimate less than 100\% of the points,
    pass the proportion to be estimated to prop.estimated
    (for example, .6 to estimate 60\% of the points).
  }
  \item{mod.dependence.formula}{
    The formula used as the base formula for the Athey-Imbens
    model dependence estimates.
  }
  \item{continuous.vars}{
    All continuous control variables in mod.dependence.formula
    must be passed as a character vector to continuous.vars. A
    cutpoint for each of these variables will be estimated
    with segmented regression.
  }
  \item{seed}{
    The seed used before estimation of the effects. If prop.estimated
    is less than 1, this is necessary in order to replicate the
    exact plot.
  }
  \item{means.as.cutpoints}{
    FALSE by default. If TRUE, cutpoints are calculated as the
    mean instead of the breakpoint in a segmented regression.
    This is sometimes much faster. 
  }
}
\examples{
data(lalonde)

match.on <- colnames(lalonde)[!(colnames(lalonde) \%in\% c('re78',
                                'treat'))]

my.frontier <- makeFrontier(dataset = lalonde,
                            treatment = 'treat',
                            outcome = 're78',
                            match.on = match.on)

my.form <- as.formula(re78 ~ treat + age + black + education + hispanic +
                          married + nodegree + re74 + re75)
\dontrun{
my.estimates <- estimateEffects(my.frontier, 're78 ~ treat',
                                mod.dependence.formula = my.form,
                                continuous.vars = c('age', 'education', 're74', 're75'),
                                prop.estimated = .1,
                                means.as.cutpoints = TRUE)
}
}
\references{
  King, Gary, Christopher Lucas, and Richard
  Nielsen. "The Balance-Sample 
  Size Frontier in Matching Methods for Causal Inference." (2015).
}
