//
//              LAPACK++ 1.1 Linear Algebra Package 1.1
//               University of Tennessee, Knoxvilee, TN.
//            Oak Ridge National Laboratory, Oak Ridge, TN.
//        Authors: J. J. Dongarra, E. Greaser, R. Pozo, D. Walker
//                 (C) 1992-1996 All Rights Reserved
//
//                             NOTICE
//
// Permission to use, copy, modify, and distribute this software and
// its documentation for any purpose and without fee is hereby granted
// provided that the above copyright notice appear in all copies and
// that both the copyright notice and this permission notice appear in
// supporting documentation.
//
// Neither the Institutions (University of Tennessee, and Oak Ridge National
// Laboratory) nor the Authors make any representations about the suitability 
// of this software for any purpose.  This software is provided ``as is'' 
// without express or implied warranty.
//
// LAPACK++ was funded in part by the U.S. Department of Energy, the
// National Science Foundation and the State of Tennessee.
//
// Modifications Copyright (C) 2000-2000, 2002 the R Development Core Team

#include "lafnames.h"
#include VECTOR_DOUBLE_H

#include "laexcp.h"

VectorDouble::VectorDouble(int n=0)
    : p(new vrefDouble()), data(new double[n])
{                                                                      
    if (!(n>=0))
        throw(LaException("assert failed : n>=0"));
    p->sz = n;                                                          
    p->data = data;
    p->ref_count = 1;                        
}                                                                      

VectorDouble::VectorDouble( const VectorDouble& m)
    : p(m.p), data(m.data)
{
    p->ref_count++;
}

VectorDouble::VectorDouble(double *d, int n)
    : p(new vrefDouble()), data(d)
{
    p->sz = n;                                                          
    p->ref_count = 2; 
    p->data = data;
}                                                                      

VectorDouble::~VectorDouble()
{
    if (--(p->ref_count) == 0)	// perform garbage collection
    {
        delete [] p->data;
        delete p;
    }
}

VectorDouble::VectorDouble(int n, double scalar)
    : p(new vrefDouble()), data(new double[n])
{
    p->sz = n;                                                          
    p->ref_count = 1;                        
    p->data = data;
    for (int i = 0; i < n; i++) { data[i] = scalar; }
}                                                                      

// this actually frees memory first, then resizes it.  it reduces
// internal fragmentation of memory pool, and the resizing of
// matrices > 1/2 available memory.

int VectorDouble::resize(int d)
{
    if (d < 0) { return size(); } // do nothing if invalid size
    ref(VectorDouble(0));	// possibly free up destination
    if (d > 0) { ref(VectorDouble(d)); }
    return size();
}

VectorDouble& VectorDouble::inject(const VectorDouble& m)
{
    if (m.size() != size())
    {
	throw(LaException("VectorDouble::inject(): vector sizes do not match."));
    }
    int N = size();
    for (int i = 0; i < N; i++) { (*this)(i) = m(i); }
    return *this;
}

VectorDouble& VectorDouble::copy(const VectorDouble &m)
{
#if 0
    if (null()) resize(m.size());
    
    if (size() != m.size())
	error("VectorDouble::copy(VectorDouble &): incompatible vector sizes : %d vs. %d", size(), m.size());
    else
#endif // 0

#if 0
	resize(0);                  // free up destination
    
    int N = m.size();
    VectorDouble tmp(N);
    
    for (int i = 0; i < N; i++)     // should use memcpy() here...
	(*this)(i) = m(i);

    ref(tmp);
    return *this;
#endif
    int N = m.size();
    resize(N);

    for (int i=0; i<N; i++) { data[i] = m.data[i]; }
    return *this;
}

std::ostream& operator<<(std::ostream& s, const VectorDouble& m)
{
    if (m.p) {
        int n = m.size();
        for (int i = 0; i < n; i++) { s << m(i) << "  "; }
        s << std::endl;
    } else { s << "NULL VectorDouble." << std::endl; }
    return s;
}

VectorDouble& VectorDouble::operator=(double scalar)
{
    for (int i = 0; i < size(); i++) { data[i] = scalar; }
    return *this;
}
