% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R, R/slice_coo.R
\name{slice}
\alias{slice}
\alias{[,RsparseMatrix,index,index,logical-method}
\alias{[,RsparseMatrix,missing,index,logical-method}
\alias{[,RsparseMatrix,index,missing,logical-method}
\alias{[,RsparseMatrix,missing,missing,logical-method}
\alias{[,RsparseMatrix,index,index,missing-method}
\alias{[,RsparseMatrix,missing,index,missing-method}
\alias{[,RsparseMatrix,index,missing,missing-method}
\alias{[,RsparseMatrix,missing,missing,missing-method}
\alias{[,ANY,nsparseVector,nsparseVector,logical-method}
\alias{[,ANY,missing,nsparseVector,logical-method}
\alias{[,ANY,nsparseVector,missing,logical-method}
\alias{[,ANY,index,nsparseVector,logical-method}
\alias{[,ANY,nsparseVector,index,logical-method}
\alias{[,ANY,nsparseVector,nsparseVector,missing-method}
\alias{[,ANY,missing,nsparseVector,missing-method}
\alias{[,ANY,nsparseVector,missing,missing-method}
\alias{[,ANY,index,nsparseVector,missing-method}
\alias{[,ANY,nsparseVector,index,missing-method}
\alias{[,ANY,lsparseVector,lsparseVector,logical-method}
\alias{[,ANY,missing,lsparseVector,logical-method}
\alias{[,ANY,lsparseVector,missing,logical-method}
\alias{[,ANY,index,lsparseVector,logical-method}
\alias{[,ANY,lsparseVector,index,logical-method}
\alias{[,ANY,lsparseVector,lsparseVector,missing-method}
\alias{[,ANY,missing,lsparseVector,missing-method}
\alias{[,ANY,lsparseVector,missing,missing-method}
\alias{[,ANY,index,lsparseVector,missing-method}
\alias{[,ANY,lsparseVector,index,missing-method}
\alias{[,CsparseMatrix,index,index,logical-method}
\alias{[,CsparseMatrix,missing,index,logical-method}
\alias{[,CsparseMatrix,index,missing,logical-method}
\alias{[,CsparseMatrix,missing,missing,logical-method}
\alias{[,CsparseMatrix,index,index,missing-method}
\alias{[,CsparseMatrix,missing,index,missing-method}
\alias{[,CsparseMatrix,index,missing,missing-method}
\alias{[,CsparseMatrix,missing,missing,missing-method}
\alias{[,TsparseMatrix,index,index,logical-method}
\alias{[,TsparseMatrix,missing,index,logical-method}
\alias{[,TsparseMatrix,index,missing,logical-method}
\alias{[,TsparseMatrix,missing,missing,logical-method}
\alias{[,TsparseMatrix,index,index,missing-method}
\alias{[,TsparseMatrix,missing,index,missing-method}
\alias{[,TsparseMatrix,index,missing,missing-method}
\alias{[,TsparseMatrix,missing,missing,missing-method}
\title{Sparse Matrices Slicing}
\usage{
\S4method{[}{RsparseMatrix,index,index,logical}(x, i, j, drop)

\S4method{[}{RsparseMatrix,missing,index,logical}(x, i, j, drop)

\S4method{[}{RsparseMatrix,index,missing,logical}(x, i, j, drop)

\S4method{[}{RsparseMatrix,missing,missing,logical}(x, i, j, drop)

\S4method{[}{RsparseMatrix,index,index,missing}(x, i, j, drop)

\S4method{[}{RsparseMatrix,missing,index,missing}(x, i, j, drop)

\S4method{[}{RsparseMatrix,index,missing,missing}(x, i, j, drop)

\S4method{[}{RsparseMatrix,missing,missing,missing}(x, i, j, drop)

\S4method{[}{ANY,nsparseVector,nsparseVector,logical}(x, i, j, drop)

\S4method{[}{ANY,missing,nsparseVector,logical}(x, i, j, drop)

\S4method{[}{ANY,nsparseVector,missing,logical}(x, i, j, drop)

\S4method{[}{ANY,index,nsparseVector,logical}(x, i, j, drop)

\S4method{[}{ANY,nsparseVector,index,logical}(x, i, j, drop)

\S4method{[}{ANY,nsparseVector,nsparseVector,missing}(x, i, j, drop)

\S4method{[}{ANY,missing,nsparseVector,missing}(x, i, j, drop)

\S4method{[}{ANY,nsparseVector,missing,missing}(x, i, j, drop)

\S4method{[}{ANY,index,nsparseVector,missing}(x, i, j, drop)

\S4method{[}{ANY,nsparseVector,index,missing}(x, i, j, drop)

\S4method{[}{ANY,lsparseVector,lsparseVector,logical}(x, i, j, drop)

\S4method{[}{ANY,missing,lsparseVector,logical}(x, i, j, drop)

\S4method{[}{ANY,lsparseVector,missing,logical}(x, i, j, drop)

\S4method{[}{ANY,index,lsparseVector,logical}(x, i, j, drop)

\S4method{[}{ANY,lsparseVector,index,logical}(x, i, j, drop)

\S4method{[}{ANY,lsparseVector,lsparseVector,missing}(x, i, j, drop)

\S4method{[}{ANY,missing,lsparseVector,missing}(x, i, j, drop)

\S4method{[}{ANY,lsparseVector,missing,missing}(x, i, j, drop)

\S4method{[}{ANY,index,lsparseVector,missing}(x, i, j, drop)

\S4method{[}{ANY,lsparseVector,index,missing}(x, i, j, drop)

\S4method{[}{CsparseMatrix,index,index,logical}(x, i, j, drop)

\S4method{[}{CsparseMatrix,missing,index,logical}(x, i, j, drop)

\S4method{[}{CsparseMatrix,index,missing,logical}(x, i, j, drop)

\S4method{[}{CsparseMatrix,missing,missing,logical}(x, i, j, drop)

\S4method{[}{CsparseMatrix,index,index,missing}(x, i, j, drop)

\S4method{[}{CsparseMatrix,missing,index,missing}(x, i, j, drop)

\S4method{[}{CsparseMatrix,index,missing,missing}(x, i, j, drop)

\S4method{[}{CsparseMatrix,missing,missing,missing}(x, i, j, drop)

\S4method{[}{TsparseMatrix,index,index,logical}(x, i, j, drop)

\S4method{[}{TsparseMatrix,missing,index,logical}(x, i, j, drop)

\S4method{[}{TsparseMatrix,index,missing,logical}(x, i, j, drop)

\S4method{[}{TsparseMatrix,missing,missing,logical}(x, i, j, drop)

\S4method{[}{TsparseMatrix,index,index,missing}(x, i, j, drop)

\S4method{[}{TsparseMatrix,missing,index,missing}(x, i, j, drop)

\S4method{[}{TsparseMatrix,index,missing,missing}(x, i, j, drop)

\S4method{[}{TsparseMatrix,missing,missing,missing}(x, i, j, drop)
}
\arguments{
\item{x}{A sparse matrix to subset, in any format.}

\item{i}{row indices to subset.}

\item{j}{column indices to subset.}

\item{drop}{whether to simplify 1d matrix to a vector}
}
\value{
A sparse matrix with the same storage order and dtype as `x`.
}
\description{
Natively slice CSR/CSC/COO matrices without changing the storage order.
}
\details{
\bold{Important:} When slicing sparse matrices with `drop=TRUE` (the default),
`Matrix` will drop 1-d matrices to \bold{dense} dense vectors, whereas
this package allows dropping them to either dense or \bold{sparse} vectors,
the latter of which is more efficient and is the default option.

The `drop` behavior can be changed back to dense vectors like `Matrix` does,
through \link{restore_old_matrix_behavior} or through the package options
(e.g. `options("MatrixExtra.drop_sparse" = FALSE)` - see \link{MatrixExtra-options}).

\bold{Note:} Trying to slice a sparse matrix without supplying any parameter for the
second axis (e.g. `X[1:10]`) will \bold{select whole rows} (as if it were `X[1:10,]`)
instead of selecting entries as if the input were a flattened array (which is what
`Matrix` and base R do).

This package will override the subsetting methods from `Matrix` for all
sparse matrix types. It is usually much faster for all three storage orders (especially
CSR) but in some situations could end up being slightly slower. Be aware that, in the
case of COO matrices (a.k.a. "TsparseMatrix"), the resulting object will \bold{not}
have sorted indices, which `Matrix` will oftentimes do in addition to subsetting,
at a large speed penalty.

In general, it's much faster to select rows when the input is a CSR matrix ("RsparseMatrix"),
and much faster to select columns when the input is a CSC matrix ("CsparseMatrix").
Slicing COO matrices is typically not efficient, but could end up being faster when
the slice involves random rows and random columns with repeated entries.
}
\examples{
library(Matrix)
library(MatrixExtra)
m <- rsparsematrix(20, 20, 0.1, repr="R")
inherits(m[1:2, ], "RsparseMatrix")
inherits(m[1:2, 3:4], "RsparseMatrix")
inherits(as.coo.matrix(m)[1:2, 3:4], "TsparseMatrix")
inherits(as.csc.matrix(m)[1:2, 3:4], "CsparseMatrix")

### New: slice with a sparse vector
m[as(c(TRUE,FALSE), "sparseVector"), ]

### Important!!!
### This differs from Matrix
set_new_matrix_behavior()
inherits(m[1,,drop=TRUE], "sparseVector")

### To bring back the old behavior:
restore_old_matrix_behavior()
inherits(m[1,,drop=TRUE], "numeric")
}
