% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeRange.R
\name{timeRange}
\alias{timeRange}
\title{Create a POSIXct time range}
\usage{
timeRange(
  starttime = NULL,
  endtime = NULL,
  timezone = NULL,
  unit = "sec",
  ceilingStart = FALSE,
  ceilingEnd = FALSE
)
}
\arguments{
\item{starttime}{Desired start datetime (ISO 8601).}

\item{endtime}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret dates (required).}

\item{unit}{Units used to determine time at end-of-day.}

\item{ceilingStart}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{startdate} rather than
\code{\link[lubridate]{floor_date}}}

\item{ceilingEnd}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{enddate} rather than
\code{\link[lubridate]{floor_date}}}
}
\value{
A vector of two \code{POSIXct}s.
}
\description{
Uses incoming parameters to return a pair of \code{POSIXct} times in the
proper order. Both start and end times will have \code{lubridate::floor_date()}
applied to get the nearest \code{unit}. This can be modified by specifying
\code{ceilingStart = TRUE} or \code{ceilingEnd = TRUE} in which case
\code{lubridate::ceiling_date()} will be applied.

The required \code{timezone} parameter must be one of those found in
\code{\link[base]{OlsonNames}}.

Dates can be anything that is understood by
\code{lubrdiate::parse_date_time()} including either of the following
recommended formats:

\itemize{
  \item{\code{"YYYYmmddHH[MMSS]"}}
  \item{\code{"YYYY-mm-dd HH:MM:SS"}}
}
}
\section{POSIXct inputs}{

When \code{startdate} or \code{enddate} are already \code{POSIXct} values,
they are converted to the timezone specified by \code{timezone} without
altering the physical instant in time the input represents. This is different
from the behavior of \code{\link[lubridate]{parse_date_time}} (which powers
this function), which will force \code{POSIXct} inputs into a new timezone,
altering the physical moment of time the input represents.
}

\examples{
library(MazamaCoreUtils)

timeRange("2019-01-08 10:12:15", 20190109102030, timezone = "UTC")

}
