% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_initialize.R
\name{location_initialize}
\alias{location_initialize}
\title{Create known location record with core metadata}
\usage{
location_initialize(
  longitude = NULL,
  latitude = NULL,
  stateDataset = "NaturalEarthAdm1",
  elevationService = NULL,
  addressService = NULL,
  precision = 10,
  verbose = TRUE
)
}
\arguments{
\item{longitude}{Single longitude in decimal degrees E.}

\item{latitude}{Single latitude in decimal degrees N.}

\item{stateDataset}{Name of spatial dataset to use for determining state}

\item{elevationService}{Name of the elevation service to use for determining
the elevation. Default: NULL skips this step. Accepted values: "usgs".}

\item{addressService}{Name of the address service to use for determining
the street address. Default: NULL skips this step. Accepted values: "photon".}

\item{precision}{\code{precision} argument passed on to \link{location_createID}.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Tibble with a single new known location.
}
\description{
Creates a known location record with the following columns
of core metadata:
\itemize{
\item{locationID}
\item{locationName}
\item{longitude}
\item{latitude}
\item{elevation}
\item{countryCode}
\item{stateCode}
\item{countyName}
\item{timezone}
\item{houseNumber}
\item{street}
\item{city}
\item{postalCode}
}
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  # Set up standard directories and spatial data
  spatialDataDir <- tempdir() # typically "~/Data/Spatial"
  initializeMazamaSpatialUtils(spatialDataDir)

  # Wenatchee
  lon <- -120.325278
  lat <- 47.423333
  
  locationRecord <- location_initialize(lon, lat)
  str(locationRecord)
  
}, silent = FALSE)
}
}
