% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_filterByDistance.R
\name{table_filterByDistance}
\alias{table_filterByDistance}
\title{Return known locations near a target location}
\usage{
table_filterByDistance(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Target longitude in decimal degrees E.}

\item{latitude}{Target latitude in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation.}
}
\value{
Tibble of known locations.
}
\description{
Returns a tibble of the known locations from \code{locationTbl}
that are within \code{distanceThreshold} meters of the target location
specified by \code{longitude} and \code{latitude}.
}
\note{
Only a single target location is allowed.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

# Too small a distanceThreshold will not find a match
locationTbl \%>\%
  table_filterByDistance(
    longitude = -117.3647, 
    latitude = 47.6725, 
    distanceThreshold = 10
  ) \%>\% 
  dplyr::glimpse()

# Expanding the distanceThreshold will find several
locationTbl \%>\%
  table_filterByDistance(
    longitude = -117.3647, 
    latitude = 47.6725, 
    distanceThreshold = 10000
  ) \%>\%
  dplyr::glimpse()
}
