% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SimpleCountriesEEZ}
\alias{SimpleCountriesEEZ}
\title{Simplified spatial dataset of EEZ/country combined boundaries.}
\format{
A simple features data frame with 319 records and 5 columns of data.
}
\usage{
SimpleCountriesEEZ
}
\description{
SimpleCountriesEEZ is a simplified world borders dataset with a
200 mile coastal buffer corresponding to Exclusive Economic Zones, suitable for
quick spatial searches. This dataset is distributed with the package and is
used by default in \code{getCountry()}, \code{getCountryCode()} and
\code{getCountryName()}.
}
\details{
This dataset is equivalent to EEZCountries but with fewer columns of data.
}
\seealso{
convertEEZCountries

This dataset was generated on 2022-11-03 by running:

\preformatted{
library(MazamaSpatialUtils)
setSpatialDataDir("~/Data/Spatial_0.8")

convertEEZCountries()

loadSpatialData("EEZCountries_05")

SimpleCountriesEEZ <- EEZCountries_05[,c("countryCode", "countryName", "polygonID")]
save(SimpleCountriesEEZ, file = "data/SimpleCountriesEEZ.rda")
}
}
\keyword{datasets}
