% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_trimDate.R
\name{sts_trimDate}
\alias{sts_trimDate}
\title{Trim \emph{sts} time series object to full days}
\usage{
sts_trimDate(sts = NULL, timezone = NULL)
}
\arguments{
\item{sts}{SingleTimeSeries \emph{sts} object.}

\item{timezone}{Olson timezone used to interpret dates.}
}
\value{
A subset of the incoming \emph{sts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Trims the date range of a \emph{sts} object to local time date
boundaries which are \emph{within} the range of data. This has the effect
of removing partial-day data records at the start and end of the timeseries
and is useful when calculating full-day statistics.

Day boundaries are calculated using the specified \code{timezone} or, if
\code{NULL}, from \code{sts$meta$timezone}.
}
\examples{
library(MazamaTimeSeries)

UTC_week <- sts_filterDate(
  example_sts,
  startdate = 20180808,
  enddate = 20180815,
  timezone = "UTC"
)

# UTC day boundaries
head(UTC_week$data)

# Trim to local time day boundaries
local_week <- sts_trimDate(UTC_week)
head(local_week$data)

}
