% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MedSurvey.R
\name{med.summary}
\alias{med.summary}
\title{To print the summary results of the mediation analysis}
\usage{
med.summary(fit = NULL, med.eff = NULL, p.adj.method = c("holm",
  "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr"))
}
\arguments{
\item{fit}{The model fit results of a mediation model. Note that it is a lavaan object.}

\item{med.eff}{A vector of labels. The labels should be of the mediation effects in the estimated model.}

\item{p.adj.method}{The method used to adjust for multiplicity (\code{'holm'} or \code{'hochberg'} or \code{'hommel'} or \code{'bonferroni'} or \code{'BH'} or \code{'BY'} or \code{'fdr'}).
Conservative method includes the Bonferroni correction ('bonferroni') in which the p-values are multiplied by the number of comparisons.
Less conservative corrections are also included by Holm (1979) ('holm'), Hochberg (1988) ('hochberg'), Hommel (1988) ('hommel'), Benjamini & Hochberg (1995) ('BH' or its alias 'fdr'), and Benjamini & Yekutieli (2001) ('BY'), respectively.
It is 'holm' by default. It is not required.}
}
\value{
A list including the effect labels, estimates, standard errors, p values, and adjusted p values if there are more than one mediation effects.
}
\description{
This function is used to print the summary results of the mediation analysis with adjustment for multiplicity.
}
\examples{
\dontshow{
 #Toy example for check:
R <- 20
wgtnames <- paste("repwgt", seq(0,R,by=1), sep="")
mwgtname=wgtnames[1]
repwgtnames=wgtnames[2:(R+1)]
model2 <- ' # outcome
              numcg ~ u0*1 + c*workban + b1*sp_adltban + b2*sp_kidsban
            # mediator
              sp_adltban ~ u1*1 + a1*workban
              sp_kidsban ~ u2*1 + a2*workban
            #covariance of residuals
              sp_adltban ~~ sp_kidsban
            # indirect effect (a*b)
              a1b1 := a1*b1
              a2b2 := a2*b2
            # total effect
              total := c + (a1*b1) + (a2*b2)
           '
fit.BRR2 <- med.fit.BRR(model=model2, data=MedData, mwgtname=mwgtname,
             repwgtnames=repwgtnames)
med.summary(fit=fit.BRR2, med.eff=c('a1b1' , 'a2b2'))
}
\donttest{
R <- 160
wgtnames <- paste("repwgt", seq(0,R,by=1), sep="")
mwgtname=wgtnames[1]
repwgtnames=wgtnames[2:(R+1)]
fayfactor=0.5

model2 <- ' # outcome
              numcg ~ u0*1 + c*workban + b1*sp_adltban + b2*sp_kidsban
            # mediator
              sp_adltban ~ u1*1 + a1*workban
              sp_kidsban ~ u2*1 + a2*workban
            #covariance of residuals
              sp_adltban ~~ sp_kidsban
            # indirect effect (a*b)
              a1b1 := a1*b1
              a2b2 := a2*b2
            # total effect
              total := c + (a1*b1) + (a2*b2)
           '
fit.BRR2 <- med.fit.BRR(model=model2, data=MedData, mwgtname=mwgtname,
             repwgtnames=repwgtnames, fayfactor)
temp <- med.summary(fit=fit.BRR2, med.eff=c('a1b1' , 'a2b2'))
#
# MedSurvey 1.0
#
# Multimediation with Complex Survey Data:
#
#   Effect             Est.          BRR SE.          p Value      adj.p Value
#
#   a1b1     -0.017475544      0.006014820      0.003667674      0.007335347
#   a2b2     -0.007244189      0.005870823      0.217228711      0.217228711
#
# NOTE:
#   p Value adjustment method is holm
#   Standard errors type is BRR SE.
#
#
######################################
# To catch the unformatted results:
temp
#
# $med.label
# [1] "a1b1" "a2b2"
#
# $med.est
# [1] -0.017475544 -0.007244189
#
# $med.se
# [1] 0.006014820 0.005870823
#
# $org.p.value
# [1] 0.003667674 0.217228711
#
# $adj.p.value
# [1] 0.007335347 0.217228711
#
# $se.type
# [1] "BRR SE."
#
# $p.adj.method
# [1] "holm"
#
}

}
\references{
Benjamini, Y., & Hochberg, Y. (1995). Controlling the false discovery rate: a practical and powerful approach to multiple testing. Journal of the Royal Statistical Society Series B, 57, 289–300. DOI:10.2307/2346101

Benjamini, Y., & Yekutieli, D. (2001). The control of the false discovery rate in multiple testing under dependency. Annals of Statistics, 29, 1165–1188. DOI:10.1214/aos/1013699998

Holm, S. (1979). A simple sequentially rejective multiple test procedure. Scandinavian Journal of Statistics, 6, 65–70.

Hommel, G. (1988). A stagewise rejective multiple test procedure based on a modified Bonferroni test. Biometrika, 75, 383–386. DOI:10.1093/biomet/75.2.383

Hochberg, Y. (1988). A sharper Bonferroni procedure for multiple tests of significance. Biometrika, 75, 800–803. DOI:10.1093/biomet/75.4.800

Mai, Y., Ha, T., & Soulakova, J. N. (2019). Multimediation Method With Balanced Repeated Replications For Analysis Of Complex Surveys. Structural Equation Modeling: A Multidisciplinary Journal. DOI:10.1080/10705511.2018.1559065

Rosseel, Y. (2012). Lavaan: An R package for structural equation modeling and more. Version 0.5–12 (BETA). Journal of statistical software, 48(2), 1-36. DOI:10.18637/jss.v048.i02

Shaffer, J. P. (1995). Multiple hypothesis testing. Annual Review of Psychology, 46, 561–576.

Sarkar, S. (1998). Some probability inequalities for ordered MTP2 random variables: a proof of Simes conjecture. Annals of Statistics, 26, 494–504. DOI:10.1214/aos/1028144846
}
