% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2rcreate.R
\name{getgenotypes_R}
\alias{getgenotypes_R}
\title{fetch genotype matrix for specified markers (assemble by rows)}
\usage{
getgenotypes_R(markers_arg, sepstr = "", envir = ENV)
}
\arguments{
\item{markers_arg}{a data.frame with the following 5 observations:
\describe{
\item{locus_link}{is the ordinal ranking of this marker among all loci}
\item{locus_link_fill}{is the position of corresponding genotype data in the
\emph{unified_genotype_table}}
\item{MarkerName}{is the text name of the marker}
\item{chromosome}{is the integer chromosome number}
\item{position}{is the integer base pair position of marker}
 }}

\item{sepstr}{separator string for alleles (default is none)}

\item{envir}{an environment that contains all the data frames created from the SQLite database.}
}
\value{
a matrix of genotypes represented as a nucleotide pair.  There is one column for each
 marker in \emph{markers_arg} argument.  There is one row for each person in the family
 (\emph{fam}) table.
}
\description{
This function calls the C++ function that does all the heavy lifting.  It passes the
 locus_index and the locus_offset in the \emph{unified_genotype_table} from the
 \emph{markers_arg} argument.  It also gathers other data.frames that are in the "global"
 \bold{ENV} environment. One frame contains a bit vector of compressed genotype information,
 another contains the alleles for each marker, and finally there are some bookkeeping related
 data.  Note this function is for Testing only and is not exported.
}
\details{
The \emph{unified_genotype_table} contains one raw vector for each person.  In the vector
 there are two bits for each genotype.  This function creates an output matrix by selecting
 from each row all the needed markers and then repeating for each person.
}
\examples{
\dontrun{
# genotypes for all persons in markers data.frame argument
getgenotypes_R(ENV$markers)

# genotypes for all persons in chromosome n
getgenotypes_R(ENV$markers[ENV$markers$chromosome == n,])
}
}
\keyword{internal}
