fluidPage(
    fluidRow(
        box(title="Welcome",
            # height="600px",
            collapsible=FALSE,
            width=12,
            p("This app provides distance-based and volume-overlap-based agreement measures for 3D structures stored in mesh files.",
              "The general approach is to calculate agreement measures for all pairwise comparisons, and aggregate the individual results.",
              "The application motivating development of MeshAgreement is to compare delineated structures for radiotherapy treatment planning."),
            p("In order to export 3D mesh files in PLY format from Varian Eclipse, you can use an",
              tags$a(href="Export3D.cs", "ESAPI script"),
              "."),
            p("This is a joint project by the",
              tags$a(href="https://www.unimedizin-mainz.de/imbei/", 
                     "Institute of Medical Biostatistics, Epidemiology and Informatics (IMBEI)"),
              "together with the",
              tags$a(href="https://www.unimedizin-mainz.de/radioonkologie-und-strahlentherapie/startseite/startseite.html", 
                     "Department of Radiation Oncology and Radiotherapy"),
              "at the",
              tags$a(href="https://www.unimedizin-mainz.de/", 
                     "University Medical Center"),
              "of the",
              tags$a(href="https://www.uni-mainz.de/", 
                     "Johannes Gutenberg-University Mainz"),
              ". The section",
              actionButton(inputId="bttn_home_go_about1",
                           label="About"),
              "gives more information on the calculated agreement measures, and lists contributors as well as software tools.")
        ),
        box(title="Usage",
            # title = "Usage",
            # height="600px",
            collapsible=FALSE,
            width=12,
            tags$img(src="img_screenshot.png", 
                     title="Screenshot", 
                     width="760",
                     height="385"),
            tags$ul(tags$li("I - Green area: navigation between sections"),
                    tags$ul(tags$li("Load data: Upload mesh files defining volumes which should be compared"),
                            tags$li("Agreement: View results for pairwise agreement as well as for average agreement"),
                            tags$li("View: Interactive 3D plots for a pair of meshes with their union and intersection"),
                            tags$li("About: Background information on methods and contributors")),
                    tags$li("II - Orange area: Main output region"),
                    tags$li("III - Purple area: Toggle fullscreen mode"))
        )
    )
)
