% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMetaAnalysis.R
\name{runMetaAnalysis}
\alias{runMetaAnalysis}
\title{Run the meta-analysis algorithm}
\usage{
runMetaAnalysis(metaObject, runLeaveOneOutAnalysis= TRUE, maxCores=Inf)
}
\arguments{
\item{metaObject}{a metaObject which must have \code{metaObject$originalData} populated with a list of \code{datasetObjects} that will be used for discovery}

\item{runLeaveOneOutAnalysis}{TRUE to run leave one out analysis, FALSE otherwise (default: TRUE)}

\item{maxCores}{maximum number of cores to use during analysis (default: Inf)}
}
\value{
modified version of the \code{metaObject} with \code{$metaAnalysis} and \code{$leaveOneOutAnalysis} populated
}
\description{
Given a \code{metaObject} with \code{$originalData} populated this function will run the meta-analysis algorithm.      
It returns a modified version of the \code{metaObject} with the meta-analysis results written into \code{metaObject$metaAnalysis} and the results of the leave-one-out analysis into \code{metaObject$leaveOneOutAnalysis}
}
\details{
To make sure the input is correctly formatted, the input \code{metaObject} should be checked with \code{checkDataObject(metaObject, "Meta", "Pre-Analysis")} before starting the meta-analysis.
}
\examples{
#Run a meta analysis. 
#		maxCores is set to 1 for package guideline compliance. 
#		For personal purposes, leave parameter un-set.
runMetaAnalysis(tinyMetaObject, maxCores=1)
}
\seealso{
\code{\link{checkDataObject}}
}
\author{
Francesco Vallania, Aditya M. Rao
}
\keyword{methods}
