% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSampleLevelGeneData.R
\name{getSampleLevelGeneData}
\alias{getSampleLevelGeneData}
\title{Extract gene-level data from a given data object}
\usage{
getSampleLevelGeneData(datasetObject, geneNames)
}
\arguments{
\item{datasetObject}{a Dataset object that is used to extract sample level data (At least, must have a \code{$expr} of probe-level data, and \code{$keys} of probe:gene mappings).}

\item{geneNames}{A vector of geneNames}
}
\value{
Returns a data frame with expression levels of only the genes of interest, for each sample in the dataset. 
	Mostly used internally, but has been exposed to the user to allow advanced functionality on external datasets if desired.
}
\description{
Given a \code{datsetObject}, and a set of target genes, this function will summarize probe-level data to gene-level data for the target genes. Returns a data frame with only the genes of interest, for each sample in the dataset.
}
\details{
Summarizes probe-level data to gene-level data, using the mean of the probes, according to the probe:gene mapping in the \code{$keys} item in the dataset object. This is done only for the genes in the filter object.
}
\examples{
sampleResults <- getSampleLevelGeneData(datasetObject=tinyMetaObject$originalData[[1]], 
geneNames=c(tinyMetaObject$filterResults[[1]]$posGeneNames, 
  tinyMetaObject$filterResults[[1]]$negGeneNames))
}
\author{
Timothy E. Sweeney, Winston A. Haynes
}
