% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RateFunctionBuildR.R
\name{RateFunctionBuildR}
\alias{RateFunctionBuildR}
\title{RateFunctionBuildR}
\usage{
RateFunctionBuildR(type = c("linear", "sigmoid", "step"),
  C_range = c(0, 200), lin_xy_start = c(0, 0), lin_slope = 0.01,
  sig_C0 = 100, sig_k = 0.05, sig_max = 2, step_levels = c(0, 1,
  2), step_switchpoints = c(50, 150), plot.out = TRUE,
  Nplotpoints = 100)
}
\arguments{
\item{type}{Type of the function, any or multiple of "linear", "sigmoid" or "step" can be used.}

\item{C_range}{The range of node concentrations over which to plot the rate function.}

\item{lin_xy_start}{Linear parameter: the starting point for the linear curve e.g. c(0,0).}

\item{lin_slope}{Linear parameter: In case only a single point is provided, the slope is also necessary.}

\item{sig_C0}{Sigmoid parameter: The midpoint concentration.}

\item{sig_k}{Sigmoid parameter: The curve steepness.}

\item{sig_max}{Sigmoid parameter: The maximal height of the function.}

\item{step_levels}{Step function parameter: the distinct levels of the function.}

\item{step_switchpoints}{Step function parameter: The points (nr. of levels minus 1) at which a switch is made.}

\item{plot.out}{Whether to plot the resulting functions.}

\item{Nplotpoints}{The number of plotpoints for the optional plot}
}
\value{
A plot with the visualize rate function and a list with the necessary parameters
}
\description{
Build and visualize an appropriate rate multiplier function. The flow between nodes in the network is governed by certain rates.
These rates can be made dependent on the values of the source node (flow from source node to receiver node). 
With this function you can visualize different types and receive the parameters to be submitted to the simulation function.
Note that this function returns an object containing the plot parameters. The simulation function can take only function type.
}
\examples{
RateFunctionBuildR()

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
