% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVMetSpecificCoxPh.R
\name{CVMetSpecificCoxPh}
\alias{CVMetSpecificCoxPh}
\title{Cross validation for the Metabolite specific analysis}
\usage{
CVMetSpecificCoxPh(Fold = 3, Survival, Mdata, Censor, Reduce = TRUE,
  Select = 150, Prognostic = NULL, Quantile = 0.5, Ncv = 3)
}
\arguments{
\item{Fold}{Number of times in which the dataset is divided. Default is 3 which implies dataset will be divided into three groups and 2/3 of the dataset will be the train datset and 1/3 will be to train the results.}

\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator}

\item{Reduce}{A boolean parameter indicating if the metabolic profile matrix should be reduced, default is TRUE and larger metabolic profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of metabolites (default is 15) to be selected from supervised PCA. This is valid only if th argument Reduce=TRUE}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Quantile}{The cut off value for the classifier, default is the median cutoff}

\item{Ncv}{The Number of cross validation loop. Default is 50 but it is recommended to have at least 100.}
}
\value{
A object of class \code{\link[MetabolicSurv]{cvmm}} is returned with the following values
  \item{HRTrain}{The Train dataset HR statistics for each metabolite by the number of CV}
  \item{HRTest}{The Test dataset HR statistics for each metabolite by the number of CV}
  \item{train}{The selected subjects for each CV in the train dataset}
  \item{train}{The selected subjects for each CV in the test dataset}
\item{n.mets}{The number of metabolite used in the analysis}
 \item{Ncv}{The number of cross validation performed}
 \item{Rdata}{The Metabolite data matrix that was used for the analysis either same as Mdata or a reduced version.}
}
\description{
The function performs cross validation for each metabolite depending the number of fold which guides the division into the train and testing dataset. The classifier is then obtained on the training dataset to be validated on the test dataset
}
\details{
This function performs the cross validation for metabolite by metabolite analysis. The data will firstly be divided into data train dataset and test datset. Furthermore, a metabolite-specific model is fitted on train data and a classifier is built. In addition, the classifier is then evaluated on test dataset for each particular metabolite. The Process is repeated for all the full or reduced metabolites to obtaind the HR statistics of the low risk group. The following steps depends on the number of cross validation specified.
}
\examples{
\donttest{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Result = CVMetSpecificCoxPh(Fold=3,Survival=Data$Survival,
Mdata=t(Data$Mdata),Censor= Data$Censor,Reduce=TRUE,
Select=150,Prognostic=Data$Prognostic,Quantile = 0.5,Ncv=3)

## GET THE CLASS OF THE OBJECT
class(Result)     # An "cvmm" Class

##  METHOD THAT CAN BE USED FOR THE RESULT
show(Result)
summary(Result)
plot(Result)
}
}
\seealso{
\code{\link[survival]{coxph}},
\code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[MetabolicSurv]{MSpecificCoxPh}},
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
