### Name: koplsPlotScores
### Title: Plots scores from trained K-OPLS models
### Aliases: koplsPlotScores
### Keywords: multivariate

### ** Examples


## Load data set
data(koplsExample)

## Define kernel function parameter
sigma<-25

## Define number of Y-orthogonal components
nox<-3

## Construct kernel
Ktr<-koplsKernel(Xtr,NULL,'g',sigma)

## Model 
model<-koplsModel(Ktr,Ytr,1,nox,'mc','mc');

#### Visualize results

## Shows all scores as scatter plot matrix
## col.vec defines class colors and is loaded by data(koplsExample)
koplsPlotScores(model, col=col.vec)

## Shows tp1 vs to1, colored by class
## pch.vec defines class glyph types and is loaded by data(koplsExample)
koplsPlotScores(model, x=1, xsub='p', y=1, ysub='o', col=col.vec, pch=pch.vec)

## Shows to1 vs to2
koplsPlotScores(model, x=1, xsub='o', y=2, ysub='o', col=col.vec, pch=pch.vec)




