% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance_poisson.R
\name{deviance_poisson}
\alias{deviance_poisson}
\title{Poisson deviance}
\usage{
deviance_poisson(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{deviance_tweedie}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of unit Poisson deviance, see e.g. [1].
}
\examples{
deviance_poisson(1:10, (1:10)^2)
deviance_poisson(1:10, (1:10)^2, w = rep(1, 10))
deviance_poisson(1:10, (1:10)^2, w = 1:10)

}
\references{
[1] Ohlsson E. and Johansson B. (2015). Non-Life Insurance Pricing with Generalized Linear Models. Springer Nature EN. ISBN 978-3642107900.
}
\seealso{
\code{\link{deviance_tweedie}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
