% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-Mhorseshoe.R
\docType{package}
\name{Mhorseshoe}
\alias{Mhorseshoe}
\alias{Mhorseshoe-package}
\title{Mhorseshoe: Approximate Algorithm for Horseshoe Prior}
\description{
Mhorseshoe is a package for a high-dimensional Bayesian linear
modeling algorithm using a horseshoe prior. This package provides two
different algorithm functions : \code{\link{exact_horseshoe}},
\code{\link{approx_horseshoe}}. approx_horseshoe is version that can lower
the computational cost than the existing horseshoe estimator through the
approximate MCMC algorithm in the case of \eqn{p >> N} for \eqn{p}
predictors and \eqn{N} observations. You can see examples of the use of the
two algorithms through the vignette, \code{browseVignettes("Mhorseshoe")}.
}
\section{About the horseshoe estimator in this package}{

The Bayesian horseshoe estimator(Carvalho et al., 2010) has good properties
such as being robust to high-dimensional sparse data and outliers, and has
good computational efficiency, making it suitable for high-dimensional
Bayesian inference. The likelihood function of the Gaussian linear model to
be considered in this package is as follows:

\deqn{L(y\ |\ x, \beta, \sigma^2) = (\frac{1}{\sqrt{2\pi}\sigma})^{-N/2}exp
\{ -\frac{1}{2\sigma^2}(y-X\beta)^T(y-X\beta)\}}

And the form of the hierarchical model applying the horseshoe prior to
\eqn{\beta} is expressed as follows:

\deqn{\beta_{j}\ |\ \sigma^{2}, \tau^{2}, \lambda_{j}^{2}
\overset{i.i.d}{\sim} N\left(0, \sigma^{2}\tau^{2}\lambda_{j}^{2} \right),
\quad \lambda_{j}\overset{i.i.d}{\sim}C^{+}(0,1),\quad j=1,2,...,p, \\ \tau
\overset{i.i.d}{\sim}C^{+}(0,1),\quad p(\sigma^2)\propto gamma\left(
w/2, w/2\right).}

Where \eqn{C^{+}(0,1)} is a half-Cauchy distribution, \eqn{\lambda_{1}, ...,
\lambda_{p}} are local shrinkage parameters, and \eqn{\tau} is global
shrinkage parameter. In general, the disadvantage of the horseshoe estimator
is that the computational cost is large for high-dimensional data where
\eqn{p>>n}, and the computation of the algorithm is very slow. To overcome
these limitations, Johndrow et al. (2020) proposed a scalable approximate
MCMC algorithm that can reduce computational costs by introducing a
thresholding method while applying the horseshoe prior. This approximate
algorithm is implemented in \code{\link{approx_horseshoe}} of this package.
}

\section{Exact algorithm process}{

The exact algorithm process is as follows.

\deqn{\xi = \tau^{-2},\quad \eta_{j} = \lambda_{j}^{-2},\quad
j = 1,2,...,p, \\ D = diag\left(\eta_{1}^{-1},..., \eta_{p}^{-1} \right),
\quad M_{\xi} = I_{N} + \xi^{-1}XDX^{T}, \\ p(\xi | y, X, \eta) \propto
|M_{\xi}|^{-1/2}\{(w + y^{T}M_{\xi}^{-1}y) / 2 \}^{-(w + N) / 2}/
\{\sqrt{\xi}(1+\xi)\}.}
\enumerate{
\item Sample \eqn{\lambda_{j}^{-2} = \eta_{j},\ j=1,2,...,p}, using the
following posterior of \eqn{\eta_{j}} for rejection sampling.
\deqn{p(\eta_{j} | \xi, \beta_{j}, \sigma^{2}) \propto \frac{1}{1 +
\eta_{j}}exp\{-\frac{\beta_{j}^{2}\xi \eta_{j}}{2\sigma^{2}} \}.}
\item Sample \eqn{\tau^{-2} = \xi} using the proposed MH algorithm as follows.
\deqn{log(\xi^{\star}) \sim N(log(\xi), s), accept\ \xi \ w.p.\
\{p(\xi^{\star} | y, X, \eta)\xi^{\star}\}/\{p(\xi | y, X, \eta)\xi \}.}
\item Sample \eqn{\sigma^{2}}, \deqn{\sigma^{2} | y, X, \eta, \xi \sim
InvGamma\{(w + N) / 2, (w + y^{T}M_{\xi}^{-1}y) / 2 \}.}
\item Sample \eqn{\beta}, \deqn{\beta | y, X, \eta, \xi, \sigma \sim
N\left(\left(X^{T}X + \left(\xi^{-1} D \right)^{-1}\right)^{-1}X^{T}y,
\ \sigma^{2}\left(X^{T}X + \left(\xi^{-1} D \right)^{-1} \right)^{-1}
\right).}
}

Since the algorithm of this package considers the case of \eqn{p >> N},
the computational cost can be lowered by sampling \eqn{\beta} using
fast sampling(Bhattacharya et al.,2016) in the step 4.

\deqn{u \sim N_{p}(0, \xi^{-1}D),\quad f \sim N_{N}(0, I_{N}), \\
v = Xu + f,\quad v^{\star} = M_{\xi}^{-1}(y/\sigma - v), \\
\beta = \sigma(u + \xi^{-1}DX^{T}v^{\star}).}

The exact algorithm is implemented in \code{\link{exact_horseshoe}} of this
package.
}

\section{About approximate MCMC algorithm}{


In order to reduce the computational cost of the exact algorithm, the
matrix \eqn{D} to which the thresholding method is applied is called
\eqn{D_{\delta}} as follows.

\deqn{D_{\delta} = diag\left(\eta_{j}^{-1}1\left(\xi^{-1}\eta_{j}^{-1}
> \delta,\ j=1,2,...,p. \right) \right),}

If a \eqn{D_{\delta}} matrix is used instead of a \eqn{D} matrix, rows and
columns with diagonal components of 0 can be eliminated, thus reducing the
computational cost for matrix multiplication. This is called the
approximate MCMC algorithm and is implemented in
\code{\link{approx_horseshoe}}.
}

\references{
Bhattacharya, A., Chakraborty, A., & Mallick, B. K. (2016).
Fast sampling with Gaussian scale mixture priors in high-dimensional
regression. Biometrika, asw042.

Carvalho, C. M., Polson, N. G., & Scott, J. G. (2010). The
horseshoe estimator for sparse signals. Biometrika, 97(2), 465–480.

Johndrow, J., Orenstein, P., & Bhattacharya, A. (2020). Scalable Approximate
MCMC Algorithms for the Horseshoe Prior. In Journal of Machine Learning
Research (Vol. 21).
}
\author{
\strong{Maintainer}: Kang Mingi \email{leehuimin115@g.skku.edu}

Authors:
\itemize{
  \item Lee Kyoungjae \email{leekjstat@gmail.com}
}

}
\keyword{internal}
