% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_load_diagnostic_threshold.R
\name{miRNA_loadDiagnosticThreshold}
\alias{miRNA_loadDiagnosticThreshold}
\title{Load diagnostic threshold values.}
\usage{
miRNA_loadDiagnosticThreshold(inputFileName, sep = "")
}
\arguments{
\item{inputFileName}{Name of the file to be loaded. The file has to contain at least the columns 'Threshold', 'DeltaThreshold', 'ChiUp', 'DChiUp', 'ChiDown', 'DChiDown' (not necessarily in this order).}

\item{sep}{Field separator character; the default is any white space (one or more spaces or tabulations).}
}
\value{
A data frame containing all the columns present in the file.
}
\description{
This function loads from file a data frame containing the diagnostic threshold values of a trained classifier.
}
\examples{
requiredFile = paste(system.file(package="MiRNAQCD"),
	"/extdata/dataset_alpha_threshold.txt", sep='')
threshold <- miRNA_loadDiagnosticThreshold(requiredFile)
}
