% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_load_mutation.R
\name{fun_load_mutation}
\alias{fun_load_mutation}
\title{Mutation data file loader}
\usage{
fun_load_mutation(mutation_file, sample_name, ref_genome, chr_no)
}
\arguments{
\item{mutation_file}{Path of the mutation information file.}

\item{sample_name}{Sample name.}

\item{ref_genome}{Reference genome for the data.}

\item{chr_no}{Reference genome chromosome number (human=24, mouse=22).}
}
\value{
df_mutation
}
\description{
This function attempts to load the mutation information file.
}
\examples{
fun_load_mutation(
  system.file("extdata", "mutation_list.tsv", package = "MicroSEC"),
  "sample",
  BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38,
  24
)
}
