% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deseq2_edgeR.R
\name{plot_deseq2_pq}
\alias{plot_deseq2_pq}
\title{Plot DESeq2 results for a phyloseq or a DESeq2 object.}
\usage{
plot_deseq2_pq(
  data,
  contrast = NULL,
  tax_table = NULL,
  pval = 0.05,
  taxolev = "Genus",
  select_taxa = NULL,
  color_tax = "Phylum",
  tax_depth = NULL,
  verbose = TRUE,
  jitter_width = 0.1,
  ...
)
}
\arguments{
\item{data}{(required) a \code{\link{phyloseq-class}} or a
\code{\link[DESeq2]{DESeqDataSet-class}} object.}

\item{contrast}{(required) contrast specifies what comparison to extract
from the object to build a results table. See \code{\link[DESeq2]{results}}
man page for more details.}

\item{tax_table}{Required if data is a
\code{\link[DESeq2]{DESeqDataSet-class}} object.
The taxonomic table used to find the \code{taxa} and \code{color_taxa}
arguments. If data is a \code{\link{phyloseq-class}} object, data@tax_table
is used.}

\item{pval}{(default: 0.05) the significance cutoff used for optimizing
the independent filtering. If the adjusted p-value cutoff (FDR) will be a
value other than 0.05, pval should be set to that value.}

\item{taxolev}{taxonomic level of interest}

\item{select_taxa}{Either the name of the taxa (in the form of \code{\link[DESeq2:results]{DESeq2::results()}})
or a logical vector (length of the results from \code{\link[DESeq2:results]{DESeq2::results()}}) to select taxa
to plot.}

\item{color_tax}{taxonomic level used for color or a
color vector.}

\item{tax_depth}{Taxonomic depth to test for differential
distribution among contrast. If Null the analysis is done at the OTU
(i.e. Species) level. If not Null, data need to be a column name in
the \code{tax_table} slot of the \code{\link{phyloseq-class}} object.}

\item{verbose}{whether the function print some information during
the computation}

\item{jitter_width}{width for the jitter positioning}

\item{...}{Additional arguments passed on to \code{\link[DESeq2]{DESeq}}
or \code{\link[ggplot2]{ggplot}}}
}
\value{
A \code{\link{ggplot}}2 plot representing DESeq2 results
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Please cite \code{DESeq2} package if you use chis function.
}
\examples{
\donttest{
data("GlobalPatterns", package = "phyloseq")
GP <- subset_taxa(GlobalPatterns, GlobalPatterns@tax_table[, 1] == "Archaea")
GP <- subset_samples(GP, SampleType \%in\% c("Soil", "Skin"))
res <- DESeq2::DESeq(phyloseq_to_deseq2(GP, ~SampleType),
  test = "Wald", fitType = "local"
)
plot_deseq2_pq(res, c("SampleType", "Soil", "Skin"),
  tax_table = GP@tax_table, color_tax = "Kingdom"
)
plot_deseq2_pq(res, c("SampleType", "Soil", "Skin"),
  tax_table = GP@tax_table, color_tax = "Kingdom",
  pval = 0.7
)
plot_deseq2_pq(res, c("SampleType", "Soil", "Skin"),
  tax_table = GP@tax_table, color_tax = "Class",
  select_taxa = c("522457", "271582")
)
}
}
\seealso{
\code{\link[DESeq2]{DESeq}}

\code{\link[DESeq2]{results}}

\code{\link{plot_edgeR_pq}}
}
\author{
Adrien Taudière
}
