% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixt.R
\name{rmatrixt}
\alias{rmatrixt}
\alias{dmatrixt}
\title{Distribution functions for the matrix variate t distribution.}
\usage{
rmatrixt(
  n,
  df,
  mean,
  L = diag(dim(as.matrix(mean))[1]),
  R = diag(dim(as.matrix(mean))[2]),
  U = L \%*\% t(L),
  V = t(R) \%*\% R,
  list = FALSE,
  array = NULL,
  force = FALSE
)

dmatrixt(
  x,
  df,
  mean = matrix(0, p, n),
  L = diag(p),
  R = diag(n),
  U = L \%*\% t(L),
  V = t(R) \%*\% R,
  log = FALSE
)
}
\arguments{
\item{n}{number of observations for generation}

\item{df}{degrees of freedom (\eqn{>0}, may be non-integer),
\verb{df = 0, Inf} is allowed and will return a normal distribution.}

\item{mean}{\eqn{p \times q}{p * q} This is really a 'shift' rather than a
mean, though the expected value will be equal to this if
\eqn{df > 2}}

\item{L}{\eqn{p \times p}{p * p}  matrix specifying relations among the rows.
By default, an identity matrix.}

\item{R}{\eqn{q \times q}{q * q}  matrix specifying relations among the
columns. By default, an identity matrix.}

\item{U}{\eqn{LL^T}  - \eqn{p \times p}{p * p}   positive definite matrix for
rows, computed from \eqn{L} if not specified.}

\item{V}{\eqn{R^T R}  - \eqn{q \times q}{q * q}  positive definite matrix for
columns, computed from \eqn{R}  if not specified.}

\item{list}{Defaults to \code{FALSE} . If this is \code{TRUE} , then the
output will be a list of matrices.}

\item{array}{If \eqn{n = 1}  and this is not specified and \code{list}  is
\code{FALSE} , the function will return a matrix containing the one
observation. If \eqn{n > 1} , should be the opposite of \code{list} .
If \code{list}  is \code{TRUE} , this will be ignored.}

\item{force}{In \code{rmatrix}: if \code{TRUE}, will take the input of
\code{R} directly - otherwise uses \code{V} and uses Cholesky
decompositions. Useful for generating degenerate t-distributions.
Will also override concerns about potentially singular matrices
unless they are not, in fact, invertible.}

\item{x}{quantile for density}

\item{log}{logical; in \code{dmatrixt}, if \code{TRUE}, probabilities
\code{p} are given as \code{log(p)}.}
}
\value{
\code{rmatrixt} returns either a list of \eqn{n}
\eqn{p \times q}{p * q}  matrices or a
\eqn{p \times q \times n}{p * q * n}
array.

\code{dmatrixt} returns the density at \code{x}.
}
\description{
Density and random generation for the matrix variate t distribution.
}
\details{
The matrix \eqn{t}-distribution is parameterized slightly
differently from the univariate and multivariate \eqn{t}-distributions
\itemize{
\item the variance is scaled by a factor of \code{1/df}.
In this parameterization, the variance for a \eqn{1 \times 1}{1 * 1} matrix
variate \eqn{t}-distributed random variable with identity variance matrices
is \eqn{1/(df-2)} instead of \eqn{df/(df-2)}. A Central Limit Theorem
for the matrix variate \eqn{T} is then that as \code{df} goes to
infinity, \eqn{MVT(0, df, I_p, df*I_q)} converges to
\eqn{MVN(0,I_p,I_q)}.
}
}
\examples{
set.seed(20180202)
# random matrix with df = 10 and the given mean and L matrix
rmatrixt(
  n = 1, df = 10, mean = matrix(c(100, 0, -100, 0, 25, -1000), nrow = 2),
  L = matrix(c(2, 1, 0, .1), nrow = 2), list = FALSE
)
# comparing 1-D distribution of t to matrix
summary(rt(n = 100, df = 10))
summary(rmatrixt(n = 100, df = 10, matrix(0)))
# demonstrating equivalence of 1x1 matrix t to usual t
set.seed(20180204)
x <- rmatrixt(n = 1, mean = matrix(0), df = 1)
dt(x, 1)
dmatrixt(x, df = 1)
}
\references{
Gupta, Arjun K, and Daya K Nagar. 1999.
Matrix Variate Distributions.
Vol. 104. CRC Press. ISBN:978-1584880462

Dickey, James M. 1967. “Matricvariate Generalizations of the Multivariate t
Distribution and the Inverted Multivariate t
Distribution.” Ann. Math. Statist. 38 (2): 511–18.
\doi{10.1214/aoms/1177698967}
}
\seealso{
\code{\link[=rmatrixnorm]{rmatrixnorm()}},
\code{\link[=rmatrixinvt]{rmatrixinvt()}},\code{\link[=rt]{rt()}} and
\code{\link[stats:Distributions]{stats::Distributions()}}.
}
