% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varyprop.R
\name{mixregPvary}
\alias{mixregPvary}
\title{Mixture of Regression Models with Varying Mixing Proportions}
\usage{
mixregPvary(x, y, C = 2, z = NULL, u = NULL, h = NULL,
             kernel = c("Gaussian", "Epanechnikov"), ini = NULL)
}
\arguments{
\item{x}{an n by p matrix of explanatory variables. The intercept will be automatically added to x.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{z}{a vector of a variable with varying-proportions. It can be any of the variables in \code{x}.
Default is NULL, and the first variable in \code{x} will be used.}

\item{u}{a vector of grid points for the local constant regression method to estimate the proportions.
If NULL (default), 100 equally spaced grid points are automatically generated
between the minimum and maximum values of z.}

\item{h}{bandwidth for kernel density estimation. If NULL (default), the bandwidth is
calculated based on the method of Botev et al. (2010).}

\item{kernel}{character, determining the kernel function used in local constant method:
\code{Gaussian} or \code{Epanechnikov}. Default is \code{Gaussian}.}

\item{ini}{initial values for the parameters. Default is NULL, which obtains the initial values
using the \code{\link{regmixEM}} function of the `mixtools' package.
If specified, it can be a list with the form of
\code{list(pi, beta, var)}, where
\code{pi} is a vector of length C of mixing proportions,
\code{beta} is a (p + 1) by C matrix for component regression coefficients, and
\code{var} is a vector of length C of component variances.}
}
\value{
A list containing the following elements:
\item{pi_u}{length(u) by C matrix of estimated mixing proportions at grid points.}
\item{pi_z}{n by C matrix of estimated mixing proportions at z.}
\item{beta}{(p + 1) by C matrix of estimated component regression coefficients.}
\item{var}{C-dimensional vector of estimated component variances.}
\item{loglik}{final log-likelihood.}
}
\description{
`mixregPvary' is used to estimate a mixture of regression models with varying proportions:
\deqn{Y|_{\boldsymbol{x},Z=z} \sim \sum_{c=1}^C\pi_c(z)N(\boldsymbol{x}^{\top}\boldsymbol{\beta}_c,\sigma_c^2).}
The varying proportions are estimated using a local constant regression method (kernel regression).
}
\examples{
n = 100
C = 2
u = seq(from = 0, to = 1, length = 100)
true_beta = cbind(c(4, - 2), c(0, 3))
true_var = c(0.09, 0.16)
data = mixregPvaryGen(n, C)
x = data$x
y = data$y
est = mixregPvary(x, y, C, z = x, u, h = 0.08)
}
\references{
Huang, M. and Yao, W. (2012). Mixture of regression models with varying mixing proportions:
a semiparametric approach. Journal of the American Statistical Association, 107(498), 711-724.

Botev, Z. I., Grotowski, J. F., and Kroese, D. P. (2010). Kernel density estimation via diffusion.
The Annals of Statistics, 38(5), 2916-2957.
}
\seealso{
\code{\link{mixregPvaryGen}}
}
