% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiregGLEM.R
\name{semimrGlobal}
\alias{semimrGlobal}
\title{Semiparametric Mixtures of Nonparametric Regressions with Global EM-type Algorithm}
\usage{
semimrGlobal(x, y, u = NULL, h = NULL, ini = NULL)
}
\arguments{
\item{x}{a vector of covariate values.}

\item{y}{a vector of response values.}

\item{u}{a vector of grid points for spline method to estimate the proportions.
If NULL (default), 100 equally spaced grid points are automatically generated
between the minimum and maximum values of x.}

\item{h}{bandwidth for the nonparametric regression. If NULL (default), the bandwidth is
calculated based on the method of Botev et al. (2010).}

\item{ini}{initial values for the parameters. Default is NULL, which obtains the initial values
using regression spline approximation. If specified, it can be a list with the form of
\code{list(pi, mu, var)}, where
\code{pi} is a vector of length 2 of mixing proportions,
\code{mu} is a length(x) by 2 matrix of component means, and
\code{var} is a vector of length 2 of component variances.}
}
\value{
A list containing the following elements:
\item{pi}{vector of length 2 of estimated mixing proportions.}
\item{mu}{length(x) by 2 matrix of estimated mean functions at x, \eqn{m(x)}.}
\item{mu_u}{length(u) by 2 matrix of estimated mean functions at grid point u, \eqn{m(u)}.}
\item{var}{vector of length 2 estimated component variances.}
\item{lik}{final likelihood.}
}
\description{
`semimrGlobal' is used to estimate a mixture of regression models, where the mixing proportions
and variances remain constant, but the component regression functions are smooth functions (\eqn{m(\cdot)})
of a covariate. The model is expressed as follows:
\deqn{\sum_{j=1}^C\pi_j\phi(y|m(x_j),\sigma^2_j).}
This function provides the one-step backfitting estimate using the global EM-type algorithm (GEM) (Xiang and Yao, 2018).
As of version 1.1.0, this function supports a two-component model.
}
\examples{
# produce data that matches the description using semimrGen function
# true_mu = (4 - sin(2 * pi * x), 1.5 + cos(3 * pi * x))
n = 100
u = seq(from = 0, to = 1, length = 100)
true_p = c(0.3, 0.7)
true_var = c(0.09, 0.16)
out = semimrGen(n, true_p[1], true_var, u)

x = out$x
y = out$y
true_mu = out$true_mu
true = list(true_p = true_p, true_mu = true_mu, true_var = true_var)

# estimate parameters using semimrGlobal function.
est = semimrGlobal(x, y)
}
\references{
Xiang, S. and Yao, W. (2018). Semiparametric mixtures of nonparametric regressions.
Annals of the Institute of Statistical Mathematics, 70, 131-154.

Botev, Z. I., Grotowski, J. F., and Kroese, D. P. (2010). Kernel density estimation via diffusion.
The Annals of Statistics, 38(5), 2916-2957.
}
\seealso{
\code{\link{semimrLocal}}, \code{\link{semimrGen}}
}
