% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixtureMissing.R
\name{summary.MixtureMissing}
\alias{summary.MixtureMissing}
\title{Summary for Mixture Missing}
\usage{
\method{summary}{MixtureMissing}(object, ...)
}
\arguments{
\item{object}{A \code{MixtureMissing} object.}

\item{...}{Arguments to be passed to methods, such as graphical parameters.}
}
\value{
No return value, called to summarize the fitted model's results
}
\description{
Summarizes main information regarding a \code{MixtureMissing} object.
}
\details{
Information includes the model used to fit the data set, initialization
  method, clustering table, total outliers, outliers per cluster, mixing proportions,
  component means and variances.
}
\examples{

data('nm_5_noise_close_100')

#++++ With no missing values ++++#

# X <- nm_5_noise_close_100[, 1:2]
# mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
# summary(mod)

#++++ With missing values ++++#

set.seed(1234)

X <- hide_values(nm_5_noise_close_100[, 1:2], prop_cases = 0.1)
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
summary(mod)

}
