% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pedigree.R
\name{get.pedigree}
\alias{get.pedigree}
\title{Derive pedigree}
\usage{
get.pedigree(population, database = NULL, gen = NULL, cohorts = NULL,
  founder.zero = TRUE, raw = FALSE)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{founder.zero}{Parents of founders are displayed as "0" (default: TRUE)}

\item{raw}{Set to TRUE to not convert numbers into Sex etc.}
}
\value{
Pedigree-file for in gen/database/cohorts selected individuals
}
\description{
Derive pedigree for selected individuals
}
\examples{
data(ex_pop)
get.pedigree(ex_pop, gen=2)
}
