% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMoTBF.R
\name{MoTBF-Distribution}
\alias{MoTBF-Distribution}
\alias{rMoTBF}
\alias{inversionMethod}
\title{Random Generation for MoTBFs}
\usage{
rMoTBF(size, fx, domain = NULL)

inversionMethod(size, fx, domain = NULL, data = NULL)
}
\arguments{
\item{size}{A \code{"numeric"} value indicating the number of records to generate.}

\item{fx}{An object of class \code{"motbf"}.}

\item{domain}{A \code{"numeric"} vector with two values indicating the range where generating
the data sample. By default it is \code{NULL} and the range is taken of the function, \code{fx}.}

\item{data}{A \code{"numeric"} vector which contains the data which we want to compare with the generated 
function. By default it is \code{NULL}, if not the empirical cumulative distribution is plotted and the 
Kolmogorov Smirnov test is used to compare the generated sample and the data.}
}
\value{
\code{rMoTBF()} returns a \code{"numeric"} vector containing the simulated values. \code{inversionMethod()} 
returns a list with the simulated values and the results of the test, it also shows a plot with the \bold{cdf}
of the original data and the generated one by screen.
}
\description{
Random generation for mixtures of truncated basis functions defined in a specific domain.
The inversion method is used. It is a technique to get random samples from a 
probability distribution.
}
\examples{

## 1. EXAMPLE
## Data
X <- rnorm(1000, mean = 5, sd = 3)

## Learning
f <- univMoTBF(X, POTENTIAL_TYPE="MOP", nparam=10)
plot(f, xlim = f$Domain)

## Random sample
Y <- rMoTBF(size = 500, fx = f)
ks.test(X,Y)

## Plots
hist(Y, prob = TRUE, add = TRUE)

## 2. EXAMPLE 
## Data
X <- rweibull(5000, shape=2)

## Learning
f <- univMoTBF(X, POTENTIAL_TYPE="MOP", nparam=10)
plot(f, xlim = f$Domain)

## Random sample
inv <- inversionMethod(size = 500, fx = f, data = X)
attributes(inv)
inv$test
Y <- inv$sample 

## Plots
plot(f, xlim = f$Domain)
hist(Y, prob = TRUE, add = TRUE)

}
\seealso{
\link{integralMoTBF}
}
