% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mte.R
\name{derivMTE}
\alias{derivMTE}
\title{Derivative MTE}
\usage{
derivMTE(fx)
}
\arguments{
\item{fx}{An \code{"motbf"} object of the \code{'mte'} subclass.}
}
\value{
The derivative which is also an \code{"motbf"} function.
}
\description{
Compute the derivative of an \code{"motbf"} object with \code{'mte'} subclass.
}
\examples{

## 1. EXAMPLE
X <- rexp(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
derivMTE(Px)

## 2. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
derivMTE(Px)

\dontrun{
## 3. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
derivMTE(Px)
## Error in derivMTE(Px): fx is an 'motbf' function but not 'mte' subclass.
class(Px)
subclass(Px)
}
}
\seealso{
\link{univMoTBF} for learning and \link{derivMoTBF} for 
general \code{"motbf"} models.
}
