% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/barycenter.r
\name{barycenter}
\alias{barycenter}
\title{calculates the barycenters for all faces of a triangular mesh}
\usage{
barycenter(mesh)
}
\arguments{
\item{mesh}{triangular mesh of class 'mesh3d'}
}
\value{
k x 3 matrix of barycenters for all \code{k} faces of input mesh.
}
\description{
calculates the barycenters for all faces of a triangular mesh
}
\examples{
require(rgl)
data(nose)
bary <- barycenter(shortnose.mesh)
\dontrun{
##visualize mesh
wire3d(shortnose.mesh)
# visualize barycenters
points3d(bary, col=2)
## now each triangle is equipped with a point in its barycenter
}
}
\seealso{
\code{\link{closemeshKD}}
}

